/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.builder;

import com.google.inject.Inject;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.structuredtextalgorithm.resource.STAlgorithmResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.ui.validation.ValidationUtil;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.IToBeBuiltComputerContribution;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.resource.IResourceDescription;

public class STAlgorithmToBeBuiltComputerContribution
implements IToBeBuiltComputerContribution {
    @Inject
    private IBuilderState builderState;

    public void removeProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) {
    }

    public void updateProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) throws CoreException {
    }

    public boolean removeStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        IFile file;
        if (storage instanceof IFile && STAlgorithmResource.isValidFileExtension((String)(file = (IFile)storage).getFileExtension())) {
            return this.removeTypeEntry(toBeBuilt, file);
        }
        return false;
    }

    protected boolean removeTypeEntry(ToBeBuilt toBeBuilt, IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        toBeBuilt.getToBeDeleted().add(uri);
        this.collectRelatedURIs(uri, toBeBuilt.getToBeDeleted());
        return true;
    }

    public boolean updateStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        TypeEntry typeEntry;
        IFile file;
        if (storage instanceof IFile && STAlgorithmResource.isValidFileExtension((String)(file = (IFile)storage).getFileExtension()) && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file)) != null) {
            return this.updateTypeEntry(toBeBuilt, typeEntry);
        }
        return false;
    }

    protected boolean updateTypeEntry(ToBeBuilt toBeBuilt, TypeEntry typeEntry) {
        URI uri = typeEntry.getURI();
        toBeBuilt.getToBeUpdated().add(uri);
        this.collectRelatedURIs(uri, toBeBuilt.getToBeDeleted());
        LibraryElement type = typeEntry.getType();
        if (type != null) {
            TreeIterator contents = type.eAllContents();
            while (contents.hasNext()) {
                EObject next = (EObject)contents.next();
                if (next instanceof Attribute) {
                    Attribute attribute = (Attribute)next;
                    STAlgorithmToBeBuiltComputerContribution.updateAttribute(toBeBuilt, attribute);
                    continue;
                }
                if (!(next instanceof VarDeclaration)) continue;
                VarDeclaration varDeclaration = (VarDeclaration)next;
                STAlgorithmToBeBuiltComputerContribution.updateVarDeclaration(toBeBuilt, varDeclaration);
            }
        }
        return true;
    }

    protected static void updateAttribute(ToBeBuilt toBeBuilt, Attribute attribute) {
        if (attribute.getType() instanceof AnyType && !InternalAttributeDeclarations.isInternalAttribute((AttributeDeclaration)attribute.getAttributeDeclaration()) && !STCoreUtil.isSimpleAttributeValue((Attribute)attribute, (boolean)false)) {
            STAlgorithmToBeBuiltComputerContribution.updateElement(toBeBuilt, (EObject)attribute);
        }
    }

    protected static void updateVarDeclaration(ToBeBuilt toBeBuilt, VarDeclaration varDeclaration) {
        if (varDeclaration.isArray() && !ValidationUtil.isContainedInTypedInstance((IInterfaceElement)varDeclaration) && !TypeDeclarationParser.isSimpleTypeDeclaration((String)varDeclaration.getArraySize().getValue())) {
            STAlgorithmToBeBuiltComputerContribution.updateElement(toBeBuilt, (EObject)varDeclaration.getArraySize());
        }
        if (!STCoreUtil.isSimpleInitialValue((VarDeclaration)varDeclaration, (boolean)false)) {
            STAlgorithmToBeBuiltComputerContribution.updateElement(toBeBuilt, (EObject)varDeclaration.getValue());
        }
    }

    protected static void updateElement(ToBeBuilt toBeBuilt, EObject element) {
        Resource resource = element.eResource();
        URI uri = resource.getURI().appendQuery(resource.getURIFragment(element));
        toBeBuilt.getToBeUpdated().add(uri);
        toBeBuilt.getToBeDeleted().remove(uri);
    }

    protected void collectRelatedURIs(URI uri, Set<URI> result) {
        StreamSupport.stream(this.builderState.getAllResourceDescriptions().spliterator(), false).map(IResourceDescription::getURI).filter(candidate -> candidate.hasQuery() && candidate.trimQuery().equals(uri)).forEach(result::add);
    }

    public boolean isPossiblyHandled(IStorage storage) {
        IFile file;
        return storage instanceof IFile && TypeLibraryManager.INSTANCE.getTypeEntryForFile(file = (IFile)storage) != null;
    }

    public boolean isRejected(IFolder folder) {
        return false;
    }
}

