/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.options.PortSide;

public class SelfLoopEdge {
    private final LEdge lEdge;
    private SelfHyperLoop slHyperLoop;
    private final SelfLoopPort slSource;
    private final SelfLoopPort slTarget;

    SelfLoopEdge(LEdge lEdge, SelfLoopPort slSource, SelfLoopPort slTarget) {
        assert (lEdge.isSelfLoop());
        assert (slSource.getLPort() == lEdge.getSource());
        assert (slTarget.getLPort() == lEdge.getTarget());
        this.lEdge = lEdge;
        this.slSource = slSource;
        this.slTarget = slTarget;
        slSource.getOutgoingSLEdges().add(this);
        slTarget.getIncomingSLEdges().add(this);
    }

    public LEdge getLEdge() {
        return this.lEdge;
    }

    public SelfHyperLoop getSLHyperLoop() {
        return this.slHyperLoop;
    }

    void setSLHyperLoop(SelfHyperLoop slLoop) {
        assert (this.slHyperLoop == null);
        this.slHyperLoop = slLoop;
    }

    public SelfLoopPort getSLSource() {
        return this.slSource;
    }

    public SelfLoopPort getSLTarget() {
        return this.slTarget;
    }

    public boolean isInline() {
        for (LLabel label : this.lEdge.getLabels()) {
            if (!((Boolean)label.getProperty(LayeredOptions.EDGE_LABELS_INLINE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public PortSide getLabelSide() {
        return this.slHyperLoop.getSLLabels().getSide();
    }
}

