/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

class ByteVector
implements Cloneable {
    private byte[] buffer = new byte[64];
    private int size = 0;

    public Object clone() throws CloneNotSupportedException {
        ByteVector bv = (ByteVector)super.clone();
        bv.buffer = (byte[])this.buffer.clone();
        return bv;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] copy() {
        byte[] b = new byte[this.size];
        ByteVector.arraycopy(this.buffer, b, this.size);
        return b;
    }

    public int read(int offset) {
        if (offset < 0 || this.size <= offset) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this.buffer[offset];
    }

    public void write(int offset, int value) {
        if (offset < 0 || this.size <= offset) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this.buffer[offset] = (byte)value;
    }

    public void add(int code) {
        this.addGap(1);
        this.buffer[this.size - 1] = (byte)code;
    }

    public void addGap(int length) {
        if (this.size + length > this.buffer.length) {
            int newSize = this.size << 1;
            if (newSize < this.size + length) {
                newSize = this.size + length;
            }
            byte[] newBuf = new byte[newSize];
            ByteVector.arraycopy(this.buffer, newBuf, this.size);
            this.buffer = newBuf;
        }
        this.size += length;
    }

    private static void arraycopy(byte[] src, byte[] dest, int size) {
        for (int i = 0; i < size; ++i) {
            dest[i] = src[i];
        }
    }
}

