// Generated by CoffeeScript 1.7.1

/*
 * @license
 * jqAwesomeStarRating  0.1.1
 * http://github.com/rcugut/jqAwesomeStarRating
 *
 * Copyright 2014, Radu Cugut <rcugut@gmail.com>
 * Licensed under MIT license.
 * http://codenapse.com
 */

(function() {
  (function($) {
    var toggleStarEl;
    toggleStarEl = function($star, state) {
      if (state) {
        return $star.removeClass('fa-star-o').addClass('fa-star');
      } else {
        return $star.removeClass('fa-star').addClass('fa-star-o');
      }
    };
    return $.fn.awesomeStarRating = function(options) {
      var $inputScore, $ratingContainer, $star, i, inputName, onChangeCallback, ratingScore, stars, _i, _results;
      if (options == null) {
        options = [];
      }
      $ratingContainer = this;
      inputName = options['name'] || $ratingContainer.attr('data-name') || 'rating_score';
      ratingScore = parseInt(options['score'] || $ratingContainer.attr('data-score') || 0);
      onChangeCallback = options['onChange'];
      $inputScore = $('<input />', {
        type: 'hidden',
        value: ratingScore,
        name: inputName
      });
      $ratingContainer.append($inputScore);
      stars = [];
      _results = [];
      for (i = _i = 1; _i <= 5; i = ++_i) {
        $star = $('<i class="fa"></i>');
        toggleStarEl($star, i <= ratingScore);
        $ratingContainer.append($star);
        stars[i] = $star;
        _results.push($star.on('click', {
          idx: i
        }, function(ev) {
          var idx, s, _j;
          idx = ev.data.idx;
          $inputScore.val(idx);
          for (s = _j = 1; _j <= 5; s = ++_j) {
            toggleStarEl(stars[s], s <= idx);
          }
          if (onChangeCallback) {
            return onChangeCallback.call($ratingContainer, idx);
          }
        }));
      }
      return _results;
    };
  })(jQuery);

}).call(this);