# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/).

## [Unreleased]
### Added
- Added account module middleware to be able to plug in logic after authentication - [#31883](https://github.com/owncloud/core/issues/31883) [#31933](https://github.com/owncloud/core/issues/31933)
- occ user:list now takes a list of attributes to display - [#31115](https://github.com/owncloud/core/issues/31115)
- Added Symfony events for user preference changes - [#31266](https://github.com/owncloud/core/issues/31266)
- Added Symfony events for public links shared by email - [#31632](https://github.com/owncloud/core/issues/31632)
- Added Symfony events for accept and reject for local shares - [#31702](https://github.com/owncloud/core/issues/31702)
- Added support for Imprint and Privacy Policy URLs in web UI and email footers - [#31666](https://github.com/owncloud/core/issues/31666) [#31699](https://github.com/owncloud/core/issues/31699) [#31730](https://github.com/owncloud/core/issues/31730) [#31766](https://github.com/owncloud/core/pull/31766)
- Added HTML template for lost password email - [#31144](https://github.com/owncloud/core/issues/31144)
- Received local shares can now trigger a notification to accept or reject them, also visible in "Shared with you" section - [#31613](https://github.com/owncloud/core/issues/31613) [#31886](https://github.com/owncloud/core/issues/31886)
- Rejected shares can now be accepted again in the "Shared with you" section - [#31613](https://github.com/owncloud/core/issues/31613)
- Provide original exception via logging events - [#31623](https://github.com/owncloud/core/issues/31623)
- Share autocomplete now displays useful tooltip when typing less characters - [#31729](https://github.com/owncloud/core/issues/31729)
- Added public Webdav API for versions using a new "meta" DAV endpoint - [#31729](https://github.com/owncloud/core/pull/29207) [#29637](https://github.com/owncloud/core/pull/29637) [#31805](https://github.com/owncloud/core/issues/31805) [#31801](https://github.com/owncloud/core/issues/31801)
- Added support for retrieving file previews using Webdav endpoint - [#29319](https://github.com/owncloud/core/pull/29319) [#30192](https://github.com/owncloud/core/pull/30192) [#31748](https://github.com/owncloud/core/issues/31748) [#31788](https://github.com/owncloud/core/issues/31788) [#31862](https://github.com/owncloud/core/issues/31862) [#31865](https://github.com/owncloud/core/issues/31865)
- Added versioning support for primary object store - [#29607](https://github.com/owncloud/core/pull/29607) [#31285](https://github.com/owncloud/core/pull/31285) [#31595](https://github.com/owncloud/core/pull/31595)

### Changed
- Updated ca-bundle.crt - [#31734](https://github.com/owncloud/core/issues/31734)
- Bump symfony to 3.4.8 and other pending minor bumps - [#31221](https://github.com/owncloud/core/issues/31221)
- Bump karma from 2.0.0 to 2.0.2 in /build - [#31253](https://github.com/owncloud/core/issues/31253)
- Bump karma-jasmine from 1.1.1 to 1.1.2 in /build - [#31378](https://github.com/owncloud/core/issues/31378)
- Bump karma-coverage from 1.1.1 to 1.1.2 in /build - [#31380](https://github.com/owncloud/core/issues/31380)
- Bump zendframework/zend-inputfilter from 2.8.1 to 2.8.2 - [#31431](https://github.com/owncloud/core/issues/31431)
- Bump icewind/smb from 1.1.0 to 3.0.0 in /apps/files_external/3rdparty - [#31521](https://github.com/owncloud/core/issues/31521)
- Bump symfony 3.4.9 to 3.4.11 - [#31571](https://github.com/owncloud/core/issues/31571)
- Update jsdoc requirement to ~3.5.5 - [#30036](https://github.com/owncloud/core/issues/30036)
- Removed example theme which now lives in the [theme-example repository](https://github.com/owncloud/theme-example) - [#31447](https://github.com/owncloud/core/issues/31447)
- A user who is a member of multiple groups is now excluded from sharing if at least one of their group is configured for exclusion - [#31737](https://github.com/owncloud/core/issues/31737) [#31822](https://github.com/owncloud/core/issues/31822)
- Changed back default minimum search characters to 2 for share autocomplete due to confusion - [#31729](https://github.com/owncloud/core/issues/31729)
- Files app UI now uses new versions API through the "meta" DAV endpoint - [#29607](https://github.com/owncloud/core/pull/29607) 

### Removed
- Removed old private ajax API for previews, deprecated by DAV endpoint support - [#30254](https://github.com/owncloud/core/pull/30254)
- Bookmarks certificate was removed - [#31878](https://github.com/owncloud/core/issues/31878)

### Fixed
- Adjustments for the notifications messages of the sharing apps - [#31947](https://github.com/owncloud/core/issues/31947)
- Disable jquery globalEval - [#31972](https://github.com/owncloud/core/issues/31972)
- Work around Edge browser memory leak in web UI chunked upload - [#31884](https://github.com/owncloud/core/issues/31884)
- Don't fail if ISqlMigration doesn't return anything - [#31779](https://github.com/owncloud/core/issues/31779)
- Fixed restoring of versions for single file shares - [#31681](https://github.com/owncloud/core/issues/31681)
- Group admins are not able to create groups any more using provisioning API - [#31738](https://github.com/owncloud/core/issues/31738)
- Fix Oracle for queries using ILIKE operator - [#31466](https://github.com/owncloud/core/issues/31466)
- Improve user-sync command help description - [#31691](https://github.com/owncloud/core/issues/31691)
- Fix deletion and restoration of files in trashbin in some partial selection scenarios - [#31700](https://github.com/owncloud/core/issues/31700)
- Do not load the code of disabled theme apps - [#31478](https://github.com/owncloud/core/issues/31478)
- Fix encrypt-all and decrypt-all commands to keep shares when encrypting - [#31600](https://github.com/owncloud/core/issues/31600) [#31590](https://github.com/owncloud/core/issues/31590)
- Proceed with encrypt-all command by enabling user-keys if no mode is selected by user - [#31612](https://github.com/owncloud/core/issues/31612)
- Validate maximum length of a username - [#31664](https://github.com/owncloud/core/issues/31664)
- Save timezone as given during login - [#31493](https://github.com/owncloud/core/issues/31493)
- Fix checksum computation to not apply on read-write streams to avoid potential mismatch results - [#31619](https://github.com/owncloud/core/issues/31619)
- Exclude uploads directory from read-only cache mask, fixes guest app chunked uploads - [#31596](https://github.com/owncloud/core/issues/31596)
- Properly normalize paths for event, no &$magic needed - [#31689](https://github.com/owncloud/core/issues/31689)
- Use the correct user id in login related Symfony events - [#31605](https://github.com/owncloud/core/issues/31605)
- Fix public link dialog issue when collaborative tags app is disabled - [#31581](https://github.com/owncloud/core/issues/31581)
- Fix updating public link share in transfer ownership command - [#31176](https://github.com/owncloud/core/issues/31176) [#31953](https://github.com/owncloud/core/issues/31953)
- Do not set the password again if it hasn't changed - [#31370](https://github.com/owncloud/core/issues/31370)
- Use correct l10n to translate 'password was changed' email - [#31553](https://github.com/owncloud/core/issues/31553)
- Improve text in settings/personal App Password - [#31539](https://github.com/owncloud/core/issues/31539)
- Fix default language code example - [#31448](https://github.com/owncloud/core/issues/31448)
- Fix double slash in versioning file copy events - [#31452](https://github.com/owncloud/core/issues/31452)
- Split public password enforced capabilities based on a config - [#31499](https://github.com/owncloud/core/issues/31499)
- Fix bogus exceptions related to missing DAV nodes after deletion - [#31479](https://github.com/owncloud/core/issues/31479)
- Fix enabling of users by group admins in the web UI - [#31489](https://github.com/owncloud/core/issues/31489)
- Fix AccountMapper to return an object or throw an exception - [#31445](https://github.com/owncloud/core/issues/31445)
- Proper handling of exceptions in UserManager - [#31446](https://github.com/owncloud/core/issues/31446)
- Properly cache non-existing user in UserManager - [#31446](https://github.com/owncloud/core/issues/31446)
- Update verify checksums console output to flow more naturally - [#31449](https://github.com/owncloud/core/issues/31449)
- Subadmin shouldn't be able to add users to their groups via API - [#31337](https://github.com/owncloud/core/issues/31337)
- Catch duplicate inserts in token table - [#31460](https://github.com/owncloud/core/pull/31460) [#31794](https://github.com/owncloud/core/issues/31794) [#32041](https://github.com/owncloud/core/pull/32041)
- Fix overflowing public share names in the share panel - [#31369](https://github.com/owncloud/core/issues/31369)
- Fix occ user:sync to sync quota from preferences after upgrade if backend provided no quota - [#31360](https://github.com/owncloud/core/issues/31360)
- Fix for Redis dev editions - [#31282](https://github.com/owncloud/core/issues/31282)
- Fix mail debug message recipient field - [#31227](https://github.com/owncloud/core/issues/31227)
- Prevent infinite loop in case of error in "log" event handler - [#31247](https://github.com/owncloud/core/issues/31247)
- Fix HTTP status code when uploading virus-infected files - [#31260](https://github.com/owncloud/core/issues/31260)
- Add back robots.txt in the release - [#31248](https://github.com/owncloud/core/issues/31248)

## 10.0.8 - 2018-04-27
### Added
- Added option for user:sync to reenable formerly disabled users - [#31124](https://github.com/owncloud/core/pull/31124)
- Ability to log extra JSON fields - [#31121](https://github.com/owncloud/core/issues/31121)
- Trigger event when logging - [#31121](https://github.com/owncloud/core/issues/31121)
- Added command to verify and fix checksums - [#31008](https://github.com/owncloud/core/pull/31008)
- Introduce seen and single user sync command line features - [#31025](https://github.com/owncloud/core/issues/31025) [#31032](https://github.com/owncloud/core/issues/31032)
- Added config setting to specify minimum characters for sharing autocomplete - [#30994](https://github.com/owncloud/core/issues/30994) [#31067](https://github.com/owncloud/core/issues/31067) [#31160](https://github.com/owncloud/core/pull/31160)
- Added personal note field for link share email - [#30486](https://github.com/owncloud/core/issues/30486) [#30571](https://github.com/owncloud/core/issues/30571) [#30813](https://github.com/owncloud/core/issues/30813) [#31057](https://github.com/owncloud/core/issues/31057) [#31201](https://github.com/owncloud/core/pull/31201) [#31212](https://github.com/owncloud/core/pull/31212)
- Add conditional Logging target logfile for shared_secret and users - [#30443](https://github.com/owncloud/core/issues/30443)
- Add option to disable link share password enforcement for write-only shares - [#30408](https://github.com/owncloud/core/issues/30408) [#30774](https://github.com/owncloud/core/issues/30774) [#30787](https://github.com/owncloud/core/issues/30787)
- Add Webdav-Location header in private link redirect - [#30387](https://github.com/owncloud/core/issues/30387) [#30595](https://github.com/owncloud/core/issues/30595)
- Make syslog output configurable, introduce new default that includes the request id - [#30346](https://github.com/owncloud/core/issues/30346)
- Added "uid" parameter to "validatePassword" events - [#30334](https://github.com/owncloud/core/issues/30334)
- Added new API event for zip file download - [#30067](https://github.com/owncloud/core/issues/30067)
- Added new API event for public link creation - [#30067](https://github.com/owncloud/core/issues/30067)
- Added log entry when the "data-fingerprint" command was run - [#30281](https://github.com/owncloud/core/issues/30281)
- Added "heic" and "heif" as image mime types for thumbnails - [#30108](https://github.com/owncloud/core/issues/30108)
- Added new API events for commenting actions - [#30142](https://github.com/owncloud/core/issues/30142)
- Added "register notifier" event for use with the notification emails feature - [#30613](https://github.com/owncloud/core/issues/30613)
- Added group option to files:scan command - [#30615](https://github.com/owncloud/core/issues/30615)
- Added warning if no files to process in occ files:transfer-ownership command - [#30612](https://github.com/owncloud/core/issues/30612)
- Added user:modify command to core - [#30652](https://github.com/owncloud/core/issues/30652)
- Added config switch to enable fallback to http scheme when creating fed shares - [#30646](https://github.com/owncloud/core/issues/30646) [#31196](https://github.com/owncloud/core/issues/31196)
- Added repair step for orphaned sub-shares - [#30695](https://github.com/owncloud/core/issues/30695)
- Added repair step to fix orphaned reshares - [#31004](https://github.com/owncloud/core/issues/31004)
- Added Symfony events for configuration changes (config.php and appconfig) - [#30788](https://github.com/owncloud/core/issues/30788) [#30937](https://github.com/owncloud/core/issues/30937) [#31107](https://github.com/owncloud/core/issues/31107)
- Added Symfony event to let apps resolve private links - [#30911](https://github.com/owncloud/core/issues/30911)
- Added Symfony events for delete and create share - [#31026](https://github.com/owncloud/core/issues/31026)
- Added Symfony events for updating share attributes (expiration, password, name) - [#31120](https://github.com/owncloud/core/issues/31120)
- Added Symfony events for group membership events - [#31003](https://github.com/owncloud/core/issues/31003)
- Added Symfony events for feature change in group admin - [#31132](https://github.com/owncloud/core/issues/31132)
- Added config.php option to select apps to ignore missing signature file (mostly for themes) - [#30891](https://github.com/owncloud/core/issues/30891) [#31066](https://github.com/owncloud/core/issues/31066)
- Added ability for full-page frontend-only apps in info.xml - [#30918](https://github.com/owncloud/core/issues/30918)
- More user-friendly email address input and handling in link share dialog - [#30945](https://github.com/owncloud/core/issues/30945) [#31142](https://github.com/owncloud/core/issues/31142)

### Changed
- Set minimum php version to 5.6 in composer.json - [#31100](https://github.com/owncloud/core/issues/31100)
- Bump PHP to 5.6.33 in composer - [#30403](https://github.com/owncloud/core/issues/30403)
- Bump phpseclib/phpseclib from 2.0.3 to 2.0.10 - [#30052](https://github.com/owncloud/core/issues/30052) [#30537](https://github.com/owncloud/core/issues/30537)
- Bump phpunit and symfony/translation to match master - [#30410](https://github.com/owncloud/core/issues/30410)
- Bump guzzlehttp/guzzle from 5.3.1 to 5.3.2 - [#30217](https://github.com/owncloud/core/issues/30217)
- Bump lukasreschke/id3parser from 0.0.1 to 0.0.3 - [#30085](https://github.com/owncloud/core/issues/30085)
- Bump symfony to 3.4.5 - [#30689](https://github.com/owncloud/core/issues/30689)
- Bump symfony/translation from 3.2.4 to 3.3.16 - [#30380](https://github.com/owncloud/core/issues/30380)
- Bump latest symfony and sabre/vobject point versions - [#30266](https://github.com/owncloud/core/issues/30266)
- Bump karma from 1.5.0 to 2.0.0 in /build - [#30050](https://github.com/owncloud/core/issues/30050)
- Bump punic/punic from 1.6.5 to 3.1.0 - [#30550](https://github.com/owncloud/core/issues/30550)
- Bump symfony to 3.4.6 and Sabre vobject to 4.1.5 - [#30768](https://github.com/owncloud/core/issues/30768)
- Bump sabre/http from 4.2.3 to v4.2.4 - [#30599](https://github.com/owncloud/core/issues/30599)
- Bump jakub-onderka/php-parallel-lint from 0.9.2 to 1.0.0 - [#30626](https://github.com/owncloud/core/issues/30626)
- Bump behat/mink-extension from 2.3.0 to 2.3.1 - [#30706](https://github.com/owncloud/core/issues/30706)
- Bump league/flysystem from 1.0.42 to 1.0.43 - [#30704](https://github.com/owncloud/core/issues/30704)
- Update composer in stable10 with versions as at 2018-02-07 - [#30390](https://github.com/owncloud/core/issues/30390)
- Renamed SMB logging config.php settings from "wnd" to "smb" - [#30244](https://github.com/owncloud/core/issues/30244)
- Improved error messages in user:delete command - [#30164](https://github.com/owncloud/core/issues/30164)
- Validate email address in mail settings section - [#30315](https://github.com/owncloud/core/issues/30315)
- Only decrypt users who have already logged in with decrypt-all occ command - [#30640](https://github.com/owncloud/core/issues/30640)
- Replace usage of "create_function" in PHP - [#30714](https://github.com/owncloud/core/issues/30714)
- Provisioning API can now properly set default or zero quota - [#30755](https://github.com/owncloud/core/issues/30755)
- User quota setting can be queried through provisioning API - [#30850](https://github.com/owncloud/core/issues/30850)

### Removed
- Removed private oc_current_user Javascript variable - [#30486](https://github.com/owncloud/core/issues/30486) [#30556](https://github.com/owncloud/core/issues/30556)
- Remove app store config values from config.sample.php - [#30422](https://github.com/owncloud/core/issues/30422)
- Remove documentation of the theme option in config.sample.php - [#30350](https://github.com/owncloud/core/issues/30350)
- Remove unused config.sample.php parameters - [#30933](https://github.com/owncloud/core/issues/30933) [#30812](https://github.com/owncloud/core/issues/30812)
- Remove "Unlimited" word from quota report in personal page - [#31041](https://github.com/owncloud/core/issues/31041)

### Fixes
- Prevent background scan to scan homes of users who never logged in - [#31189](https://github.com/owncloud/core/issues/31189)
- Properly align three button dialogs - [#31147](https://github.com/owncloud/core/issues/31147)
- Many documentation improvements in config.sample.php - [#31114](https://github.com/owncloud/core/issues/31114) [#31127](https://github.com/owncloud/core/issues/31127) [#31128](https://github.com/owncloud/core/issues/31128) [#31068](https://github.com/owncloud/core/issues/31068) [#31173](https://github.com/owncloud/core/issues/31173) [#31182](https://github.com/owncloud/core/pull/31182)
- Fix some documentation paths in config.sample.php - [#30431](https://github.com/owncloud/core/issues/30431)
- Fix App Framework ApiContoller initialization to fix thumbnail access - [#31104](https://github.com/owncloud/core/issues/31104) [#31183](https://github.com/owncloud/core/pull/31183)
- Check apache auth on login form - [#31074](https://github.com/owncloud/core/issues/31074)
- Check basic auth credentials periodically after a timeout instead of … - [#31076](https://github.com/owncloud/core/issues/31076)
- Email autocomplete in link share dialog will not return local/federated users any more, only contacts - [#30998](https://github.com/owncloud/core/issues/30998)
- Fix settings page where elements are inline when they shouldn't - [#30988](https://github.com/owncloud/core/issues/30988)
- Do not log errors when uploading forbidden file format - [#30991](https://github.com/owncloud/core/issues/30991)
- Fix upload issue by replacing emittingCall with separate before and after events - [#30986](https://github.com/owncloud/core/issues/30986)
- Fix Symfony event emittingCall by adding return - [#31045](https://github.com/owncloud/core/issues/31045)
- Properly trigger file-related Symfony events when chunking - [#31087](https://github.com/owncloud/core/issues/31087)
- Remove unsupported "enable for groups" field for theme apps - [#30948](https://github.com/owncloud/core/issues/30948)
- Added OneNote 2016 user agent string to make it work with Webdav - [#30965](https://github.com/owncloud/core/issues/30965)
- Refactored metadata sync code to unify behavior across all login methods - [#30638](https://github.com/owncloud/core/issues/30638)
- Mask "marketplace.key" in config list as it is sensitive - [#30917](https://github.com/owncloud/core/issues/30917)
- Polish totp middleware a little - [#30849](https://github.com/owncloud/core/issues/30849)
- Set empty authtoken names to 'none' as empty is not allowed any more - [#30908](https://github.com/owncloud/core/issues/30908)
- Fix CORS OPTIONS request for unauthenticated requests - [#30912](https://github.com/owncloud/core/issues/30912)
- Treat any unknown app version as 0.0.1 - [#30890](https://github.com/owncloud/core/issues/30890)
- Ignore multiple slashes in http path - [#30854](https://github.com/owncloud/core/issues/30854)
- Initialize root folder service later to fix user backend registration order issue - [#30810](https://github.com/owncloud/core/issues/30810)
- Remove implicit login in base.php to remove bogus "Login failed" logs - [#30814](https://github.com/owncloud/core/issues/30814)
- Use storage specific move operation for object store - [#30817](https://github.com/owncloud/core/issues/30817)
- Fix webUI display of group containing numeric username - [#30811](https://github.com/owncloud/core/issues/30811)
- Fix calendar changes limit - [#30816](https://github.com/owncloud/core/issues/30816)
- Properly use error exit code for unsupported PHP version - [#30780](https://github.com/owncloud/core/issues/30780)
- Unbrand Personal security sessions message - [#30754](https://github.com/owncloud/core/issues/30754)
- Propagate move exception messages to the frontend - [#30791](https://github.com/owncloud/core/issues/30791)
- Fix chunk size comparison for big values on 32-bit systems - [#30772](https://github.com/owncloud/core/issues/30772)
- Make error origin more distinguishable in some filesystem code paths - [#30682](https://github.com/owncloud/core/issues/30682)
- Don't send emails when importing calendar/events - [#30666](https://github.com/owncloud/core/issues/30666)
- Adding a system configuration for global CORS domains - [#30906](https://github.com/owncloud/core/issues/30906)
- Better label for CORS in settings section - [#30663](https://github.com/owncloud/core/issues/30663)
- Allow regular users to change their CORS domains - [#30649](https://github.com/owncloud/core/issues/30649)
- Catch session unavailable exception - [#30347](https://github.com/owncloud/core/issues/30347) [#30623](https://github.com/owncloud/core/issues/30623)
- Proper HTTP status code on login exception - [#30639](https://github.com/owncloud/core/issues/30639)
- Fix file mtime issue on 32-bit systems - [#30546](https://github.com/owncloud/core/issues/30546)
- Fixing logout for app password scenario - [#30591](https://github.com/owncloud/core/issues/30591)
- Fix wording if you are not a member of any groups - [#30558](https://github.com/owncloud/core/issues/30558)
- Fix for error when querying non present log_secret - [#30470](https://github.com/owncloud/core/issues/30470)
- Properly create a session for a pure token based request, fixed oauth2 issues - [#30542](https://github.com/owncloud/core/issues/30542)
- Free resources in preview providers - [#30533](https://github.com/owncloud/core/issues/30533)
- Continue in case of rare error in files:scan repair command - [#30494](https://github.com/owncloud/core/issues/30494) [#30618](https://github.com/owncloud/core/issues/30618) [#30959](https://github.com/owncloud/core/issues/30959)
- Make theming work when theme app is outside the ownCloud root - [#30477](https://github.com/owncloud/core/issues/30477)
- Don't try decrypting federated shares in decrypt-all command - [#30155](https://github.com/owncloud/core/issues/30155)
- Keep null in getMetaData in Checksum storage wrapper, fixes some files:scan scenarios - [#30302](https://github.com/owncloud/core/issues/30302)
- Modals dialogs can now scroll, improves link share dialog UX - [#30424](https://github.com/owncloud/core/issues/30424)
- Adjust link share wording and fix translations - [#31036](https://github.com/owncloud/core/issues/31036)
- Fix failure of shares which are already moved with transfer ownership - [#30161](https://github.com/owncloud/core/issues/30161)
- Return 403 instead of 503 to resume syncing of desktop client - [#30353](https://github.com/owncloud/core/issues/30353)
- Guide users to also check spelling for typos in federated share id - [#30355](https://github.com/owncloud/core/issues/30355)
- Fixed issue with number of hidden files not updating on renaming a file - [#30359](https://github.com/owncloud/core/issues/30359)
- Fix deleted items auto expiration for users with no quota - [#30163](https://github.com/owncloud/core/issues/30163)
- Fix validation for new encryption storage key location - [#30357](https://github.com/owncloud/core/issues/30357)
- Fix some CSRF issues on Webdav endpoint by only checking for POST method - [#30358](https://github.com/owncloud/core/issues/30358)
- Prevent share icon from shrinking with long texts - [#31163](https://github.com/owncloud/core/pull/31163)
- Fixed regression where a user could not set own email address in the settings page - [#30319](https://github.com/owncloud/core/issues/30319)
- Fix caldav and carddav syncing when dealing with lots of data - [#30252](https://github.com/owncloud/core/issues/30252)
- Don't restrain width of icon-logo - [#30282](https://github.com/owncloud/core/issues/30282)
- Check trashbin permissions before moving to trash, fixes deletion as guest user - [#30240](https://github.com/owncloud/core/issues/30240)
- Handle no read access to skeleton - [#30241](https://github.com/owncloud/core/issues/30241)
- Fix file name escaping in error messages in web UI related to file operations - [#30193](https://github.com/owncloud/core/issues/30193)
- Proper error message when trying to add user to a group they are already member of in web UI - [#30194](https://github.com/owncloud/core/issues/30194)
- Show new basename and extension while waiting for rename operation to finish in web UI - [#30040](https://github.com/owncloud/core/issues/30040)
- Fix app author parsing in apps page - [#30043](https://github.com/owncloud/core/issues/30043)
- Validate system path data used in findBinaryPath - [#30061](https://github.com/owncloud/core/issues/30061)
- Fix deletion of group with special characters in web UI - [#30111](https://github.com/owncloud/core/issues/30111)
- Fix missing preview in file upload conflict window - [#30125](https://github.com/owncloud/core/issues/30125)
- Fix files endpoint bug when downloading vCard - [#30149](https://github.com/owncloud/core/issues/30149)
- Properly filter link share email parameters - [#30165](https://github.com/owncloud/core/issues/30165)
- Filter sender display name in mail notification handler - [#31056](https://github.com/owncloud/core/issues/31056)
- Filter file name when sending internal mail - [#31046](https://github.com/owncloud/core/issues/31046)
- Convert null to empty string for Oracle in file cache accessor - [#30224](https://github.com/owncloud/core/issues/30224)
- Use LargeFileHelper to calculate log file size - fixes #30227 - [#30234](https://github.com/owncloud/core/issues/30234)

## 10.0.7 - 2018-01-19
### Fixed
- Fix various issues about null user errors - [#30450](https://github.com/owncloud/core/issues/30450)
- Solve OAuth token expiry issue - [#30481](https://github.com/owncloud/core/issues/30481)
- Fixed issues related to app passwords and account lock-outs - [#30363](https://github.com/owncloud/core/issues/30363)

## 10.0.6 - 2018-01-29
### Fixed
- Fix missing build dependency for L18N - [#30265](https://github.com/owncloud/core/pull/30265)

## 10.0.5 - 2018-01-23
### Added
- Add php-intl as hard requirement - [#29539](https://github.com/owncloud/core/issues/29539)
- Optionally show server hostname in status.php - [#29471](https://github.com/owncloud/core/issues/29471)
- Add link for logfiles docs in exception page and simplify text - [#29674](https://github.com/owncloud/core/issues/29674)
- Link to trusted domains docs in error message - [#29730](https://github.com/owncloud/core/issues/29730)
- Add indices on share table - [#29883](https://github.com/owncloud/core/issues/29883) [#29592](https://github.com/owncloud/core/issues/29592)
- Add dispatcher event for "unshare from self" action - [#29851](https://github.com/owncloud/core/issues/29851)
- Technology preview for PHP 7.2 support - [#29878](https://github.com/owncloud/core/issues/29878)
- Added public hooks for file operations using Symfony Event Dispatcher - [#29939](https://github.com/owncloud/core/issues/29939)
- Expose getAppPath() and getAppWebPath() on the AppManager service [#30041](https://github.com/owncloud/core/pull/30041) [#30150](https://github.com/owncloud/core/pull/30150)
- Add warning in settings page when running in debug mode - [#29936](https://github.com/owncloud/core/issues/29936)

### Changed
- Switch Webdav URL in field in navigation panel to the new endpoint - [#29766](https://github.com/owncloud/core/issues/29766)
- Require a minimum of 1 character for the application password name - [#29831](https://github.com/owncloud/core/issues/29831)
- Only allow a single active theme app with no magic fallbacks to inactive app themes  - [#29854](https://github.com/owncloud/core/issues/29854)
- Config report now hides email address from email config - [#29949](https://github.com/owncloud/core/issues/29949)
- Change "remote" to "federated" suffix in sharing autocomplete dialog. - [#30046](https://github.com/owncloud/core/issues/30046) [#30171](https://github.com/owncloud/core/issues/30171)

### Removed
- Removed old Dropbox storage backend, people should use the [files_external_dropbox app](https://github.com/owncloud/files_external_dropbox/) instead - [#29135](https://github.com/owncloud/core/issues/29135)
- Revoke tasks.crt - [#29882](https://github.com/owncloud/core/issues/29882)
- Remove unused composer dependency on natxet/CssMin - [#29930](https://github.com/owncloud/core/issues/29930)

### Fixed
- Fix Dropbox / GDrive oauth handshake handling - [#30071](https://github.com/owncloud/core/pull/30071)
- Redisplay login page on CSRF error - [#30035](https://github.com/owncloud/core/issues/30035)
- Do not reset display name to uid on sso login - [#30038](https://github.com/owncloud/core/issues/30038)
- Do not automatically disable apps of certain types - [#29870](https://github.com/owncloud/core/issues/29870)
- Fix provisioning API when dealing with group name "0" - [#30004](https://github.com/owncloud/core/issues/30004)
- Tweak occ command help output - [#29959](https://github.com/owncloud/core/issues/29959)
- Now using upsert instead of insertIfNotExists for file cache updates, fixes concurrency issues - [#29934](https://github.com/owncloud/core/issues/29934)
- Only set CORS headers on Webdav endpoint when Origin header is specified - [#29874](https://github.com/owncloud/core/issues/29874)
- Ignore broken/dead symlinks on filescan - [#28959](https://github.com/owncloud/core/issues/28959)
- Improve performance by caching non-existing accounts - [#29866](https://github.com/owncloud/core/issues/29866)
- Fix template location order by searching the enabled theme app first - [#29867](https://github.com/owncloud/core/issues/29867)
- Actually log message instead of {$message} - [#29844](https://github.com/owncloud/core/issues/29844)
- Improved performance on new DAV endpoint by skipping querying parent nodes - [#29834](https://github.com/owncloud/core/issues/29834)
- Adjust error message about PHP compatibility to say PHP X.X like previous line. - [#29828](https://github.com/owncloud/core/issues/29828)
- Raise more useful message when constructor are not resolvable - [#29760](https://github.com/owncloud/core/issues/29760)
- Fix wording for versions expiration occ command - [#29671](https://github.com/owncloud/core/issues/29671)
- Handle invalid or missing external storage backend to keep mount point visible - [#29562](https://github.com/owncloud/core/issues/29562)
- Fix integrity check when owncloud is not installed - [#29692](https://github.com/owncloud/core/issues/29692)
- Fix issues about unsharing with some scenarios after moving the share - [#29716](https://github.com/owncloud/core/issues/29716)
- Allow group 0 to be created by provisioning API - [#29734](https://github.com/owncloud/core/issues/29734)
- Do not reset quota if it was not provided - [#29673](https://github.com/owncloud/core/issues/29673)
- Improve quota value validation - check size only if size key is set - [#29743](https://github.com/owncloud/core/issues/29743)
- Code cleanup - [#29799](https://github.com/owncloud/core/issues/29799)

## 10.0.4 - 2017-12-06
### Added
- Added support for eml mimetype - [#29204](https://github.com/owncloud/core/issues/29204)
- Added "occ dav:cleanup-chunks" command to clean up expired uploads - [#29180](https://github.com/owncloud/core/issues/29180)
- Added "occ files:scan" repair mode to repair mismatch filecache paths - [#29074](https://github.com/owncloud/core/issues/29074) [#29232](https://github.com/owncloud/core/issues/29232)
- Added occ command to change/recreate master-key - [#29260](https://github.com/owncloud/core/issues/29260) [#29735](https://github.com/owncloud/core/issues/29735)
- Detailed mode for "occ security:routes" - [#29095](https://github.com/owncloud/core/issues/29095)
- Webdav property to retrieve a private link to files or folders - [#29041](https://github.com/owncloud/core/issues/29041)
- CORS support for public API routes - [#28852](https://github.com/owncloud/core/issues/28852) [#29741](https://github.com/owncloud/core/issues/29741) [#29749](https://github.com/owncloud/core/issues/29749)
- More "files_sharing" capabilities entries - [#29040](https://github.com/owncloud/core/issues/29040)
- Display server name in admin page, don't show in status.php - [#28938](https://github.com/owncloud/core/issues/28938)
- Validate public link mail on the client side - [#29042](https://github.com/owncloud/core/issues/29042)
- Expose XHR response in share dialog autocomplete callback for extensions - [#29231](https://github.com/owncloud/core/issues/29231)
- Let apps provide icons for settings sections - [#29358](https://github.com/owncloud/core/issues/29358)
- Added cancellable prehooks for logout operation - [#29352](https://github.com/owncloud/core/issues/29352)
- Markdown support for app descriptions in apps settings panel - [#29333](https://github.com/owncloud/core/issues/29333)
- Add option to allow user to share only with the groups they belong to - [#29391](https://github.com/owncloud/core/issues/29391)
- Cacheable storage adapter for use by Flysystem based external storage backends - [#29414](https://github.com/owncloud/core/issues/29414)
- Add user additional info field for share autocomplete  - [#29457](https://github.com/owncloud/core/issues/29457)
- Add dispatcher event for remote fed shares - [#29482](https://github.com/owncloud/core/issues/29482)
- Adding mode of operations - either single-instance or clus… - [#29492](https://github.com/owncloud/core/issues/29492)
- Added support for MariaDB 10.2.7+ - [#29240](https://github.com/owncloud/core/issues/29240)
- Admins can now exclude files from integrity check in config.php - [#29460](https://github.com/owncloud/core/issues/29460)
- Use X-Request-ID header as request id if provided by client, useful for logging - [#29434](https://github.com/owncloud/core/issues/29434)
- Added authentication headers verification to validate the session - [#29525](https://github.com/owncloud/core/issues/29525)
- Added IServiceLoader on server container to load app service classes from XML tags in info.xml - [#29525](https://github.com/owncloud/core/issues/29525)
- Trigger events for federated shares - [#29566](https://github.com/owncloud/core/issues/29566)

### Changed
- Exclude mimetypelist.js from integrity check - [#29048](https://github.com/owncloud/core/issues/29048) [#29316](https://github.com/owncloud/core/issues/29316)
- Refactor set and reset of capabilities - [#29200](https://github.com/owncloud/core/issues/29200)
- All amazon locations support v4 now - v3 deprecated - [#29153](https://github.com/owncloud/core/issues/29153)
- Modified time value of files is now 64 bits long - [#28961](https://github.com/owncloud/core/issues/28961)
- User names must now be at least 3 characters long - [#29237](https://github.com/owncloud/core/issues/29237)
- AccountMapper get by email is now case insensitive - [#29341](https://github.com/owncloud/core/issues/29341)
- Remove deprecated federated share API warning as it needlessly pollutes logs - [#29364](https://github.com/owncloud/core/issues/29364)
- Improve UI for public link sharing permissions for folders - [#29413](https://github.com/owncloud/core/issues/29413)
- Replace notify user for local shares with button - [#29463](https://github.com/owncloud/core/issues/29463)
- Log out current user after submitting form in password reset page - [#29464](https://github.com/owncloud/core/issues/29464)
- Update minimum supported browser versions - [#29507](https://github.com/owncloud/core/issues/29507)
- Admins can now change display name even when its modification is disallowed for regular users - [#29442](https://github.com/owncloud/core/issues/29442)

### Removed
- Remove AvatarPermissions repair step - [#29202](https://github.com/owncloud/core/issues/29202)
- Remove unused FTP code - [#29186](https://github.com/owncloud/core/issues/29186)
- Remove app store related code obsoleted by market app - [#29249](https://github.com/owncloud/core/issues/29249)
- Remove a route to removed script - [#29553](https://github.com/owncloud/core/issues/29553)

### Fixed
- Corrected namespace for OC\Memcache\ArrayCache which caused errors on some environments - [#29219](https://github.com/owncloud/core/issues/29219)
- External storage Javascript code from apps is now loaded correctly (fixes Dropbox app and others) - [#29225](https://github.com/owncloud/core/issues/29225)
- Use product name from theme - [#29251](https://github.com/owncloud/core/issues/29251)
- Make sure the external storage folder name is editable when returning from OAuth authorization - [#29253](https://github.com/owncloud/core/issues/29253)
- Fix duplicate external storage config that appear sometimes when returning from OAuth authorization - [#29254](https://github.com/owncloud/core/issues/29254)
- Log exceptions in decrypt-all command - [#29248](https://github.com/owncloud/core/issues/29248)
- SFTP key pair mode now works again - [#29156](https://github.com/owncloud/core/issues/29156)
- Use correct class namespace for ownCloud ext storage - [#28935](https://github.com/owncloud/core/issues/28935)
- Fix generated zip file to avoid errors with some zip tools - [#29149](https://github.com/owncloud/core/issues/29149)
- Fix position of dialog boxes - [#29133](https://github.com/owncloud/core/issues/29133) [#29467](https://github.com/owncloud/core/issues/29467)
- Move 64bit mtime migration from dav to core - [#29121](https://github.com/owncloud/core/issues/29121)
- Allow 0 byte quota to be entered on UI - [#29113](https://github.com/owncloud/core/issues/29113)
- Don't display warning about limited commands when running maintenance:install - [#28968](https://github.com/owncloud/core/issues/28968)
- Handle no user session in isSharingDisabledForUser() - [#28915](https://github.com/owncloud/core/issues/28915)
- Fix icon format for federated cloud sharing - [#28972](https://github.com/owncloud/core/issues/28972)
- Fix for decrypting user specific keys - [#29189](https://github.com/owncloud/core/issues/29189)
- Remove alternate keys storage during user delete - [#29155](https://github.com/owncloud/core/issues/29155)
- Fix error logs due to deletion of keys - [#28934](https://github.com/owncloud/core/issues/28934)
- Fix encryption panel to properly detect current mode after upgrade to ownCloud 10 - [#29049](https://github.com/owncloud/core/issues/29049)
- Fix quota check when uploading to federated shares - [#29325](https://github.com/owncloud/core/issues/29325) [#29424](https://github.com/owncloud/core/issues/29424)
- Fix issue when mounting another encrypted ownCloud - [#29360](https://github.com/owncloud/core/issues/29360)
- AccountMapper get by email is now case insensitive - [#29341](https://github.com/owncloud/core/issues/29341)
- Fix order of apps to be deterministic during install process - [#29267](https://github.com/owncloud/core/issues/29267)
- Only initiate connection to federated share when necessary - [#29314](https://github.com/owncloud/core/issues/29314)
- Allow group named "0" to be deleted - [#29323](https://github.com/owncloud/core/issues/29323)
- Do not translate CORS header in settings page - [#29313](https://github.com/owncloud/core/issues/29313)
- Disable background scan for home storage/cache - [#29306](https://github.com/owncloud/core/issues/29306)
- Fixed double escaping in full page error messages - [#29304](https://github.com/owncloud/core/issues/29304)
- Updated davclient.js which fixes issue whenever an app extends Array prototype - [#29305](https://github.com/owncloud/core/issues/29305)
- Fix OCS apps API to correctly include attributes into generated XML - [#29303](https://github.com/owncloud/core/issues/29303)
- Make enum type mapping work with migrations - [#29268](https://github.com/owncloud/core/issues/29268)
- Handle invalid storage when getting storage root id - [#29278](https://github.com/owncloud/core/issues/29278)
- Fix storing/retrieval for dav properties of non files - [#29273](https://github.com/owncloud/core/issues/29273)
- Remove double quotes from boolean values in status.php output - [#29271](https://github.com/owncloud/core/issues/29271)
- Tidy code in DAV related classes - [#29272](https://github.com/owncloud/core/issues/29272)
- Fix the missing argument to DecryptAll - [#29371](https://github.com/owncloud/core/issues/29371)
- Skip copying skeleton files if skeleton dir is not accessible - [#29379](https://github.com/owncloud/core/issues/29379)
- Use chunked DB query when preloading directory content for DAV properties - [#29416](https://github.com/owncloud/core/issues/29416)
- Fix failure when checking integrity signature for non-existing files - [#29433](https://github.com/owncloud/core/issues/29433)
- Prevent uploading of part files through WebDav - [#29432](https://github.com/owncloud/core/issues/29432)
- Only trigger "changeUser" event if account object really changed - [#29429](https://github.com/owncloud/core/issues/29429)
- Only load app type once in app manager classes - [#29428](https://github.com/owncloud/core/issues/29428)
- Use efficient startsWith implementation in server container - [#29427](https://github.com/owncloud/core/issues/29427)
- Fix race condition in browser when uploading folder tree - [#29435](https://github.com/owncloud/core/issues/29435)
- Disable nginx buffering for file downloads to avoid huge memory usage in some scenarios - [#29403](https://github.com/owncloud/core/issues/29403)
- Fix many issues related to session removal - [#28879](https://github.com/owncloud/core/issues/28879)
- Fix SMB to better detect when overwriting through rename - [#29564](https://github.com/owncloud/core/issues/29564)
- Fix files scan repair in bulk warning - [#29631](https://github.com/owncloud/core/issues/29631)
- Fix federated share import from public link - [#29677](https://github.com/owncloud/core/issues/29677)
- Fix status.php to properly display product name - [#29728](https://github.com/owncloud/core/issues/29728)
- Sort allowed storages checkbox list - [#29746](https://github.com/owncloud/core/issues/29746)

## [10.0.3] - 2017-09-15
### Added
- It is now possible to upgrade from 8.2.11 directly to 10 - [#28655](https://github.com/owncloud/core/issues/28655) [#28673](https://github.com/owncloud/core/pull/28673)
- Added extra check in case of missing home storage - [#28504](https://github.com/owncloud/core/issues/28504)
- Added Shield and Workflow icons - [#28588](https://github.com/owncloud/core/issues/28588)
- Enable chunking for big files in web UI when logged in - [#28547](https://github.com/owncloud/core/issues/28547)
- Added emitting of hook "post_unshareFromSelf" to Share 2.0 - [#28413](https://github.com/owncloud/core/issues/28413)
- Added occ user:inactive command to list inactive users - [#28294](https://github.com/owncloud/core/issues/28294)
- Added internal setting for the periodic credentials validity check - [#28298](https://github.com/owncloud/core/issues/28298)
- Added jquery events for external storage settings UI when using OAuth - [#28210](https://github.com/owncloud/core/issues/28210)
- Added public IThemeService which allows apps like the template editor to interact with the current theme - [#28647](https://github.com/owncloud/core/issues/28647) [#28926](https://github.com/owncloud/core/issues/28926)
- Added "passwordEnabled" field to hook data of link shares - [#28827](https://github.com/owncloud/core/issues/28827)
- Add new option to disable sharing in every user-mounted external storages - [#28706](https://github.com/owncloud/core/issues/28706)
- Added default user and group share permissions - [#28903](https://github.com/owncloud/core/issues/28903)
- Added occ command to list routes - [#28907](https://github.com/owncloud/core/issues/28907)
- Added mime types for m3u, m3u8, pls mappings to audio streams - [#28885](https://github.com/owncloud/core/issues/28885)

### Changed
- Transfer ownership now works with master key encryption - [#28537](https://github.com/owncloud/core/issues/28537) [#28845](https://github.com/owncloud/core/issues/28845)
- Reenable medial search by default - [#28064](https://github.com/owncloud/core/issues/28064)
- The LoginController now emits "failedLogin" hook signal after a failed login - [#28631](https://github.com/owncloud/core/issues/28631)
- All columns that use the fileid have been changed to bigint (64-bits) - [#28581](https://github.com/owncloud/core/issues/28581)
- Added search pattern for the occ app:list command - [#28653](https://github.com/owncloud/core/issues/28653)
- Allow phpredis develop branch - [#28717](https://github.com/owncloud/core/issues/28717)
- Default minimum desktop version in config.php is now 2.2.4 - [#28540](https://github.com/owncloud/core/issues/28540)
- Reallow negative mtimes by default in storage implementations - [#28697](https://github.com/owncloud/core/issues/28697)

### Deprecated
### Removed
- Removed "themes" folder - [#28617](https://github.com/owncloud/core/issues/28617) [#28999](https://github.com/owncloud/core/issues/28999)
- Removed unused Windows checks - [#28612](https://github.com/owncloud/core/issues/28612)
- Removed "appstoreenabled" from config.php - [#28714](https://github.com/owncloud/core/issues/28714)
- Slash in filename when renaming is not allowed any more in the frontend (unintended "feature") - [#28490](https://github.com/owncloud/core/issues/28490)
- Using old chunking protocol on new DAV endpoint is now disallowed - [#28637](https://github.com/owncloud/core/issues/28637)

### Fixed
#### Platform
- Fix issue with folder sizes on 32-bit systems - [#28654](https://github.com/owncloud/core/issues/28654)
- Fix null error in ActivityManager on some setups - [#28420](https://github.com/owncloud/core/issues/28420)
- Load app code before running app specific migrations - [#28391](https://github.com/owncloud/core/issues/28391)
- Prevent certificate manager to access FS too early, fixes 8.2 to 10 migration issue - [#28668](https://github.com/owncloud/core/pull/28668)
- Clustering: Better support of read only config file and apps folder - [#28594](https://github.com/owncloud/core/issues/28594) [#28601](https://github.com/owncloud/core/issues/28601)
- Only use IndexIgnore in htaccess if mod_autoindex.c is enabled/loaded - [#28591](https://github.com/owncloud/core/issues/28591)
- Fix app enable of not existing app - [#28317](https://github.com/owncloud/core/issues/28317)
- Keep redirect information when logging in with wrong password - [#28511](https://github.com/owncloud/core/issues/28511)
- Use SwiftMailer antiflood plugin to reconnect after multiple emails sent - [#28180](https://github.com/owncloud/core/issues/28180)
- Theme is now properly loaded when displaying full page error messages - [#28622](https://github.com/owncloud/core/pull/28622)
- Adjusted warning for PHP 5.5 EOL - [#28765](https://github.com/owncloud/core/issues/28765)
- Don't enable market app on upgrade from OC < 10 if "appstoreenabled" was false in config.php - [#28757](https://github.com/owncloud/core/issues/28757)
- Use different CSS comment style for IE11 support - [#28752](https://github.com/owncloud/core/issues/28752)
- Adjust default slogan - [#28724](https://github.com/owncloud/core/issues/28724)
- Catch filecache inconsistencies instead of logging warnings - [#28710](https://github.com/owncloud/core/issues/28710)
- Check for null when traversing app passwords table rows - [#28894](https://github.com/owncloud/core/issues/28894)
- Improve market upgrade messages + new switch - [#28871](https://github.com/owncloud/core/issues/28871)
- Make occ upgrade verbose by default - [#28876](https://github.com/owncloud/core/issues/28876)
- Add more information to updatechecker config doc - [#28867](https://github.com/owncloud/core/issues/28867)

#### Database
- All columns that use the fileid have been changed to bigint (64-bits) - [#28581](https://github.com/owncloud/core/issues/28581)
- Fix length of account search term column which broke installs on some DB setups - [#28576](https://github.com/owncloud/core/issues/28576)
- Fix column lengths on migrations table to fix index - [#28254](https://github.com/owncloud/core/issues/28254)
- Fixed some repeated duplicate key errors relate to oc_preferences table - [#28486](https://github.com/owncloud/core/issues/28486)
- Add migration step to fix birthday calendars - [#28338](https://github.com/owncloud/core/issues/28338)
- Added cache for new card uri-id mapping to fix db cluster execution - [#28308](https://github.com/owncloud/core/issues/28308)

#### Performance
- Optimize upload - don't fetch info of non-existing file - [#28704](https://github.com/owncloud/core/issues/28704)
- Optimize upload - don't check if file exists if already known - [#28704](https://github.com/owncloud/core/issues/28704)
- Optimize upload - do not fetch metadata for part file during checksuming - [#28633](https://github.com/owncloud/core/issues/28633)
- Optimize shares retrieval logic with complex scenarios - [#28524](https://github.com/owncloud/core/issues/28524)
- Optimize query logger - [#28220](https://github.com/owncloud/core/issues/28220)
- Remove initial scanning overhead to speed up federated shares with lots of entries - [#28604](https://github.com/owncloud/core/issues/28604)
- Improve contact search performance - [#28042](https://github.com/owncloud/core/issues/28042)
- Improved search performance for federated instance users - [#28209](https://github.com/owncloud/core/issues/28209)
- Add database index on "oc_share.share_with" column - [#28856](https://github.com/owncloud/core/issues/28856)

#### Filesystem / storage
- Don't trigger hooks for every new dav chunk, only for final file - [#28817](https://github.com/owncloud/core/issues/28817)
- Prevent creating file cache inconsistencies when moving a subtree in or out of a share - [#28219](https://github.com/owncloud/core/issues/28219)
- Add check for empty result in storage memcache - [#28548](https://github.com/owncloud/core/issues/28548)
- Fix error message when accessing of non-existing file on external storage - [#28613](https://github.com/owncloud/core/issues/28613)
- Fixed OAuth frontend logic when connecting to external storage - [#28496](https://github.com/owncloud/core/issues/28496) [#28400](https://github.com/owncloud/core/issues/28400)
- Fix quota handling on new Webdav endpoint (affects desktop client 2.2+) - [#28261](https://github.com/owncloud/core/issues/28261)
- Fix mounting Webdav as drive in Windows 10 - [#28243](https://github.com/owncloud/core/issues/28243)
- Fix rare error that happens when mounting invalid shares - [#28342](https://github.com/owncloud/core/issues/28342)
- Handle BSD case for 32 bit filemtime and install warning - [#28790](https://github.com/owncloud/core/issues/28790)
- Properly check target rename path in new dav endpoint - [#28737](https://github.com/owncloud/core/issues/28737)
- Increment required only when encryption is enabled - [#28880](https://github.com/owncloud/core/issues/28880)

#### Files app
- Make sure passed upload mtime is always an int - [#28186](https://github.com/owncloud/core/issues/28186)
- Fix directory mime type in trashbin list - [#28803](https://github.com/owncloud/core/issues/28803)
- Properly highlight files when opening private link - [#28681](https://github.com/owncloud/core/issues/28681)
- Fix overlapping selectively in default fileslist - [#28906](https://github.com/owncloud/core/issues/28906)
- Better timeout detection in web UI uploads + chunked uploads - [#28896](https://github.com/owncloud/core/issues/28896)
- Fix getting drop target when dragging from file manager  - [#28882](https://github.com/owncloud/core/issues/28882)
- Improve file upload progress bar - [#28861](https://github.com/owncloud/core/issues/28861)

#### Sharing
- Creating link shares now doesn't forget "Allow editing" permission any more - [#28065](https://github.com/owncloud/core/issues/28065)
- Fix "notify user" checkbox in share panel - [#28237](https://github.com/owncloud/core/issues/28237)
- Proper message shown when accessing unreachable private links - [#28600](https://github.com/owncloud/core/issues/28600)
- Fix exact search term match for LDAP in share autocomplete - [#28851](https://github.com/owncloud/core/issues/28851)
- Add tooltip to public shares panel - [#28781](https://github.com/owncloud/core/issues/28781)
- Validate share link password even if unchanged when updating share - [#28713](https://github.com/owncloud/core/issues/28713)
- Fix DiscoveryManager error during upgrade by untangling federated share app dependencies - [#28858](https://github.com/owncloud/core/pull/28858)

#### User management
- Don't set email if invalid in user:add command - [#28577](https://github.com/owncloud/core/issues/28577)
- Group admins can now properly edit members' email addresses - [#28366](https://github.com/owncloud/core/issues/28366)
- Fixed "settings_ajax_changegroupname" typo in route name - [#28746](https://github.com/owncloud/core/issues/28746)
- Use IProvidesEMailBackend to fix syncing with LDAP backend - [#28736](https://github.com/owncloud/core/issues/28736)

#### API related
- Make Backbone PROPPATCH work with options.wait mode - [#28791](https://github.com/owncloud/core/issues/28791) [#28837](https://github.com/owncloud/core/issues/28837)
- Detect PROPPATCH failure by parsing multistatus in Backbone Webdav adapter - [#28628](https://github.com/owncloud/core/issues/28628)
- Error messages from the server on upload are now displayed in the web UI instead of generic messages - [#28635](https://github.com/owncloud/core/issues/28635)
- Properly set the status text in OCS API v2 calls - [#28595](https://github.com/owncloud/core/issues/28595)
- Data was not properly set in case of OCS Result object - [#28198](https://github.com/owncloud/core/issues/28198)

#### Other
- Only reload file list when switching navigation sections - [#28843](https://github.com/owncloud/core/issues/28843)
- Make new text file tooltip messages update properly - [#28151](https://github.com/owncloud/core/issues/28151)
- Fix trashbin preview icons - [#28158](https://github.com/owncloud/core/issues/28158)
- Allow user "0" as in comments - [#28422](https://github.com/owncloud/core/issues/28422)
- Better description for occ files:scan command - [#28839](https://github.com/owncloud/core/issues/28839)
- Better description for occ files:cleanup command - [#28841](https://github.com/owncloud/core/issues/28841)
- Reworded upgrade message for admin with big instance - [#28828](https://github.com/owncloud/core/issues/28828)
- Make lost password errors distinguishable - [#28756](https://github.com/owncloud/core/issues/28756)
- Add height to menutoggler - [#28723](https://github.com/owncloud/core/issues/28723)
- Remove apostrophe from full page file read error text - [#28702](https://github.com/owncloud/core/issues/28702)
- Added missing "fatal" log level to occ log:manage level command - [#28683](https://github.com/owncloud/core/issues/28683)

## [10.0.2] - 2017-06-30

- [major] Fix issue with database.xml migration being triggered twice on market app install - [#27982](https://github.com/owncloud/core/issues/27982)
- [major] Apps formerly marked as shipped can now be uninstalled - [#27985](https://github.com/owncloud/core/issues/27985)
- [major] Market now properly updates app version when using multiple apps paths - [#28002](https://github.com/owncloud/core/issues/28002)

## [10.0.1] - 2017-06-23

- [major] Clear cached app info before installing app - [#27953](https://github.com/owncloud/core/issues/27953)
- [major] Fix to allow admin login when using home object store mode - [#27963](https://github.com/owncloud/core/issues/27963)
- [major] Skeleton files correct copied for shibboleth - [#27935](https://github.com/owncloud/core/issues/27935)
- [major] Automatically enable market app when upgrading from OC < 10 - [#27930](https://github.com/owncloud/core/issues/27930)
- [major] Fix issue where market would run app migrations twice in some scenarios - market/#76
- [major] Fetch search terms from user backend (ex: LDAP) for more extended user search ability - [#27906](https://github.com/owncloud/core/issues/27906)
- [major] Added support for upload-only link shares - [#27548](https://github.com/owncloud/core/issues/27548)
- [major] When enabling default encryption module the admin must now explicitly choose encryption type (master key vs user key) - [#27512](https://github.com/owncloud/core/issues/27512)
- [major] Fix missing "publicuri" field when upgrading from 9.1.5 - [#27754](https://github.com/owncloud/core/issues/27754)
- [major] Add options to the user:sync command to handle missing accounts - [#27798](https://github.com/owncloud/core/issues/27798)
- [major] Maintenance mode now properly blocks syncing on new DAV endpoint - [#27821](https://github.com/owncloud/core/issues/27821)
- [major] Copy button for multiple link share now copies the correct link - [#27863](https://github.com/owncloud/core/issues/27863)
- [major] Fix upload issues with IE11 - [#27875](https://github.com/owncloud/core/issues/27875)
- [major] Allow apps to register multiple settings panels - [#27885](https://github.com/owncloud/core/issues/27885)
- [major] Account table doesn't sync from user backends that have no listing support - [#27862](https://github.com/owncloud/core/issues/27862)
- [major] Add events for password validation - [#27883](https://github.com/owncloud/core/issues/27883)
- [major] Add JS event after external storage mount config is loaded, for UI extensions - [#27740](https://github.com/owncloud/core/issues/27740)
- [major] Fix theming of setup page by autoloading default_enable theme apps - [#27819](https://github.com/owncloud/core/issues/27819)
- [major] Allow apps to register custom settings page sections in info.xml - [#27634](https://github.com/owncloud/core/issues/27634)
- [major] Add admin sharing option to restrict autocomplete to membership groups but still allow typing full name if known - [#27869](https://github.com/owncloud/core/issues/27869)
- [minor] Market app update now doesn't overwrite local git checkouts - [#27973](https://github.com/owncloud/core/issues/27973)
- [minor] Delete "appstoreenabled" config value when enabling market - [#27956](https://github.com/owncloud/core/issues/27956)
- [minor] Do not verify email address when entered by an admin on their personal page - [#27921](https://github.com/owncloud/core/issues/27921)
- [minor] Fix default share permission issue in public API [#27927](https://github.com/owncloud/core/issues/27927)
- [minor] Properly rethrow exception when error occurred when enabling an app - [#27970](https://github.com/owncloud/core/issues/27970)
- [minor] Remove own shares from "Shared with you" section - [#27972](https://github.com/owncloud/core/issues/27972)
- [minor] Fix updating to daily from 10.0.0 with web updater - updater/#422
- [minor] Fix updating to 10.0.1 with web updater - [#27965](https://github.com/owncloud/core/issues/27965)
- [minor] Removed unused and non-working auto-login after setup - [#27971](https://github.com/owncloud/core/issues/27971)
- [minor] Fix SMB storage to return false if stat failed - [#27859](https://github.com/owncloud/core/issues/27859)
- [minor] Update swiftmailer - [#27897](https://github.com/owncloud/core/issues/27897)
- [minor] Escape filter in search - [#27900](https://github.com/owncloud/core/issues/27900)
- [minor] Fix file name output in error pages - [#27808](https://github.com/owncloud/core/issues/27808)
- [minor] Support for alternative login buttons through config.php - [#27607](https://github.com/owncloud/core/issues/27607)
- [minor] Example theme app renamed to "theme-example" by convention - [#27632](https://github.com/owncloud/core/issues/27632)
- [minor] Fix missing translation of built-in section names - [#27645](https://github.com/owncloud/core/issues/27645)
- [minor] Add ability to disable password reset form in config - [#27676](https://github.com/owncloud/core/issues/27676)
- [minor] Add support for themed radio buttons - [#27681](https://github.com/owncloud/core/issues/27681)
- [minor] Fix customjs extension handling for external storage apps - [#27683](https://github.com/owncloud/core/issues/27683)
- [minor] Fix upgrade error with mod_fcgid and PHP 7 - [#27553](https://github.com/owncloud/core/issues/27553)
- [minor] Remove sharing subtab when link sharing is disallowed - [#27708](https://github.com/owncloud/core/issues/27708)
- [minor] Add privacy warning in link shares panel - [#27844](https://github.com/owncloud/core/issues/27844)
- [minor] Fix files app name in navigation menu - [#27843](https://github.com/owncloud/core/issues/27843)
- [minor] Fix mimetype table code to ignore folder extensions - [#27668](https://github.com/owncloud/core/issues/27668)
- [minor] Automatically focus the password field in password reset page - [#27889](https://github.com/owncloud/core/issues/27889)
- [minor] Trashbin restore warnings due to missing entries now logged as debug - [#27826](https://github.com/owncloud/core/issues/27826)
- [minor] Remove obsolete repair step RemoveOldShares - [#27737](https://github.com/owncloud/core/issues/27737)
- [minor] "local link" was renamed to "private link" - [#27594](https://github.com/owncloud/core/issues/27594)
- [minor] Fix column sorting in public file list page - [#27308](https://github.com/owncloud/core/issues/27308)

## 10.0.0 - 2017-04-26

### Added
#### General

- Allows users to add the app to the Android homescreen: [#25438](https://github.com/owncloud/core/pull/25438)
- Compatible with PHP 7.1: [#25436](https://github.com/owncloud/core/pull/25346)
- MySQL 4-byte UTF8 support: (utf8mb4 for e.g. Emoticons) [#17978](https://github.com/owncloud/core/pull/17978)
- Admin, personal pages and app management are now merged together into a single "Settings" entry: [#26449](https://github.com/owncloud/core/pull/26449)
- Admin page displays the output of the server's status.php: [#27238](https://github.com/owncloud/core/pull/27238)
- Also allow using email address for password recovery: [#27168](https://github.com/owncloud/core/pull/27168)
- Ability to disable password reset: [#27440](https://github.com/owncloud/core/issues/27440)
- Support Redis Cluster: [#26407](https://github.com/owncloud/core/pull/26407)
- ownCloud log entry reorder: [#27562](https://github.com/owncloud/core/pull/27562)
- ownCloud log file rules to split into separate files: [#27443](https://github.com/owncloud/core/pull/27443)
- occ scanner optimized memory usage for large scans by using autocommits: [owncloud/core/27527](https://github.com/owncloud/core/pull/27527)
- Third party apps are not disabled anymore when upgrading

#### Filesystem

- Ability to exclude folders from being processed, like snapshot folders: [#19235](https://github.com/owncloud/core/pull/19235)
- Checksum is computed on the fly and verified (File integrity checking): [#26655](https://github.com/owncloud/core/issues/26655) / [Technical Documentation](https://github.com/owncloud/documentation/issues/2964)

#### Files App

- Share Link can be copied to the clipboard [#25418](https://github.com/owncloud/core/pull/25418)
- Display version sizes in versions panel [#26511](https://github.com/owncloud/core/pull/26511)
- Transfer ownership now works for individual folders [#27343](https://github.com/owncloud/core/pull/27343)
- Favorite star indicator now visible in the file lists related to sharing (ex: "Shared with you") [#19753](https://github.com/owncloud/core/issues/19753)

#### User management

- Ability to disable users in the users page (enable column first under cog icon) [#27333](https://github.com/owncloud/core/pull/27333)
- When changing personal email, an email confirmation is now sent [#7326](https://github.com/owncloud/core/issues/7326)
- When password is changed through any means, the user will now receive an email [#27498](https://github.com/owncloud/core/pull/27498)
- Change user preferences through OCC [#24770](https://github.com/owncloud/core/issues/24770)

#### External storage

- "Local" storage type can now be disabled by sysadmin in config.php [#26653](https://github.com/owncloud/core/issues/26653)
- External storage backends must use [core external storage API](https://doc.owncloud.org/server/10.0/developer_manual/app/extstorage.html) to work without "files_external" [#18160](https://github.com/owncloud/core/issues/18160)
- FTP external storage moved to a separate app [files_external_ftp](https://github.com/owncloud/files_external_ftp)

#### Dav App

- CalDAV calendar public sharing [#25351](https://github.com/owncloud/core/pull/25351)

#### Sharing

- Support for multiple link shares: [#27337](https://github.com/owncloud/core/pull/27337)
- When a recipient moves a file or folder out of a received share, the owner now receives a backup in their trashbin: [#27042](https://github.com/owncloud/core/pull/27042)
- User avatars now visible in sharing autocomplete dropdown: [#25976](https://github.com/owncloud/core/pull/25976)

#### For developers

- Users from all user backends are now stored in a central account table, improves performance by reducing recurring backend traffic: [#23558](https://github.com/owncloud/core/issues/23558)
- Added event whenever a user is enabled or disabled: [#23970](https://github.com/owncloud/core/issues/23970)
- Added first login event: [#26206](https://github.com/owncloud/core/pull/26206)
- Added postLogout hook: [#27048](https://github.com/owncloud/core/pull/27048)
- New column in oc_jobs table to store last duration: [#27144](https://github.com/owncloud/core/pull/27144)
- Ability to specify offset and limit when doing a REPORT query on a files endpoint: [#26507](https://github.com/owncloud/core/pull/26507)
- Avatar API via WebDAV https://github.com/owncloud/core/pull/26872
- Improve return value support for two factor auth providers API - [#26593](https://github.com/owncloud/core/issues/26593)
- Apps can now register Sabre plugins in info.xml: [#26195](https://github.com/owncloud/core/issues/26195)
- REPORT method for files endpoint now allows searching for favorites: [#26099](https://github.com/owncloud/core/pull/26099)
- Group backends can now return group display names (partial support, only used by sharing autocomplete): [#26750](https://github.com/owncloud/core/pull/26750)

### Changed

- status.php now returns whether an instance requires a DB update: [#26209](https://github.com/owncloud/core/pull/26209)
- config option to hide server version in status.php [#27473](https://github.com/owncloud/core/pull/27473)
- provisioning API now also returns the user's home path: [#26850](https://github.com/owncloud/core/issues/26850)
- web updater shows link to changelog in admin page: [#26796](https://github.com/owncloud/core/issues/26796)

[Unreleased]: https://github.com/owncloud/core/compare/v10.0.8...stable10
[10.0.8]: https://github.com/owncloud/core/compare/v10.0.7...v10.0.8
[10.0.7]: https://github.com/owncloud/core/compare/v10.0.6...v10.0.7
[10.0.6]: https://github.com/owncloud/core/compare/v10.0.5...v10.0.6
[10.0.5]: https://github.com/owncloud/core/compare/v10.0.4...v10.0.5
[10.0.4]: https://github.com/owncloud/core/compare/v10.0.3...v10.0.4
[10.0.3]: https://github.com/owncloud/core/compare/v10.0.2...v10.0.3
[10.0.2]: https://github.com/owncloud/core/compare/v10.0.1...v10.0.2
[10.0.1]: https://github.com/owncloud/core/compare/v10.0.0...v10.0.1

