/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.I18N;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Vector;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;
import gps.log.out.WayPointStyle;
import gps.tracks.PolylineEncoder;
import gps.tracks.Track;
import gps.tracks.Trackpoint;

public final class GPSGmapsV3HTMLFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    private boolean isWayType;
    private boolean isNewTrack = true;
    private int currentFilter;
    private final Track track = new Track();
    private final Track waypoints = new Track();
    private int trackIndex = 0;
    private String trackOnClickFuncCalls = "";
    private final StringBuffer infoHtmls = new StringBuffer(1024);
    private final BT747Vector iconList = JavaLibBridge.getVectorInstance();
    private String trackStartInfo = "";
    private String trackDescription = "";
    private final String markerManager = "function MarkerManager(c,b){var a=this;a.map_=c;a.mapZoom_=c.getZoom();a.projectionHelper_=new ProjectionHelperOverlay(c);google.maps.event.addListener(a.projectionHelper_,'ready',function(){a.projection_=this.getProjection();a.initialize(c,b)})}MarkerManager.prototype.initialize=function(d,b){var f=this;b=b||{};f.tileSize_=MarkerManager.DEFAULT_TILE_SIZE_;var h=d.mapTypes;var i=1;for(var c in h){if(h.hasOwnProperty(c)&&h.get(c)&&h.get(c).maxZoom==='number'){var g=d.mapTypes.get(c).maxZoom;if(g>i){i=g}}}f.maxZoom_=b.maxZoom||19;f.trackMarkers_=b.trackMarkers;f.show_=b.show||true;var e;if(typeof b.borderPadding==='number'){e=b.borderPadding}else{e=MarkerManager.DEFAULT_BORDER_PADDING_}f.swPadding_=new google.maps.Size(-e,e);f.nePadding_=new google.maps.Size(e,-e);f.borderPadding_=e;f.gridWidth_={};f.grid_={};f.grid_[f.maxZoom_]={};f.numMarkers_={};f.numMarkers_[f.maxZoom_]=0;google.maps.event.addListener(d,'dragend',function(){f.onMapMoveEnd_()});google.maps.event.addListener(d,'idle',function(){f.onMapMoveEnd_()});google.maps.event.addListener(d,'zoom_changed',function(){f.onMapMoveEnd_()});f.removeOverlay_=function(a){a.setMap(null);f.shownMarkers_--};f.addOverlay_=function(a){if(f.show_){a.setMap(f.map_);f.shownMarkers_++}};f.resetManager_();f.shownMarkers_=0;f.shownBounds_=f.getMapGridBounds_();google.maps.event.trigger(f,'loaded')};MarkerManager.DEFAULT_TILE_SIZE_=1024;MarkerManager.DEFAULT_BORDER_PADDING_=100;MarkerManager.MERCATOR_ZOOM_LEVEL_ZERO_RANGE=256;MarkerManager.prototype.resetManager_=function(){var a=MarkerManager.MERCATOR_ZOOM_LEVEL_ZERO_RANGE;for(var b=0;b<=this.maxZoom_;++b){this.grid_[b]={};this.numMarkers_[b]=0;this.gridWidth_[b]=Math.ceil(a/this.tileSize_);a<<=1}};MarkerManager.prototype.clearMarkers=function(){this.processAll_(this.shownBounds_,this.removeOverlay_);this.resetManager_()};MarkerManager.prototype.getTilePoint_=function(a,c,b){var d=this.projectionHelper_.LatLngToPixel(a,c);var e=new google.maps.Point(Math.floor((d.x+b.width)/this.tileSize_),Math.floor((d.y+b.height)/this.tileSize_));return e};MarkerManager.prototype.addMarkerBatch_=function(i,d,j){var f=this;var e=i.getPosition();i.MarkerManager_minZoom=d;if(this.trackMarkers_){google.maps.event.addListener(i,'changed',function(a,b,c){f.onMarkerMoved_(a,b,c)})}var h=this.getTilePoint_(e,j,new google.maps.Size(0,0,0,0));for(var g=j;g>=d;g--){var k=this.getGridCellCreate_(h.x,h.y,g);k.push(i);h.x=h.x>>1;h.y=h.y>>1}};MarkerManager.prototype.isGridPointVisible_=function(d){var b=this.shownBounds_.minY<=d.y&&d.y<=this.shownBounds_.maxY;var e=this.shownBounds_.minX;var c=e<=d.x&&d.x<=this.shownBounds_.maxX;if(!c&&e<0){var a=this.gridWidth_[this.shownBounds_.z];c=e+a<=d.x&&d.x<=a-1}return b&&c};MarkerManager.prototype.onMarkerMoved_=function(f,b,g){var c=this.maxZoom_;var a=false;var d=this.getTilePoint_(b,c,new google.maps.Size(0,0,0,0));var e=this.getTilePoint_(g,c,new google.maps.Size(0,0,0,0));while(c>=0&&(d.x!==e.x||d.y!==e.y)){var h=this.getGridCellNoCreate_(d.x,d.y,c);if(h){if(this.removeFromArray_(h,f)){this.getGridCellCreate_(e.x,e.y,c).push(f)}}if(c===this.mapZoom_){if(this.isGridPointVisible_(d)){if(!this.isGridPointVisible_(e)){this.removeOverlay_(f);a=true}}else{if(this.isGridPointVisible_(e)){this.addOverlay_(f);a=true}}}d.x=d.x>>1;d.y=d.y>>1;e.x=e.x>>1;e.y=e.y>>1;--c}if(a){this.notifyListeners_()}};MarkerManager.prototype.removeMarker=function(d){var b=this.maxZoom_;var a=false;var e=d.getPosition();var c=this.getTilePoint_(e,b,new google.maps.Size(0,0,0,0));while(b>=0){var f=this.getGridCellNoCreate_(c.x,c.y,b);if(f){this.removeFromArray_(f,d)}if(b===this.mapZoom_){if(this.isGridPointVisible_(c)){this.removeOverlay_(d);a=true}}c.x=c.x>>1;c.y=c.y>>1;--b}if(a){this.notifyListeners_()}this.numMarkers_[d.MarkerManager_minZoom]--};MarkerManager.prototype.addMarkers=function(b,a,c){var d=this.getOptMaxZoom_(c);for(var i=b.length-1;i>=0;i--){this.addMarkerBatch_(b[i],a,d)}this.numMarkers_[a]+=b.length};MarkerManager.prototype.getOptMaxZoom_=function(a){return a||this.maxZoom_};MarkerManager.prototype.getMarkerCount=function(a){var b=0;for(var z=0;z<=a;z++){b+=this.numMarkers_[z]}return b};MarkerManager.prototype.getMarker=function(c,e,d){var b=new google.maps.LatLng(c,e);var f=this.getTilePoint_(b,d,new google.maps.Size(0,0,0,0));var g=new google.maps.Marker({position:b});var a=this.getGridCellNoCreate_(f.x,f.y,d);if(a!==undefined){for(var i=0;i<a.length;i++){if(c===a[i].getPosition().lat()&&e===a[i].getPosition().lng()){g=a[i]}}}return g};MarkerManager.prototype.addMarker=function(d,a,b){var e=this.getOptMaxZoom_(b);this.addMarkerBatch_(d,a,e);var c=this.getTilePoint_(d.getPosition(),this.mapZoom_,new google.maps.Size(0,0,0,0));if(this.isGridPointVisible_(c)&&a<=this.shownBounds_.z&&this.shownBounds_.z<=e){this.addOverlay_(d);this.notifyListeners_()}this.numMarkers_[a]++};function GridBounds(a){this.minX=Math.min(a[0].x,a[1].x);this.maxX=Math.max(a[0].x,a[1].x);this.minY=Math.min(a[0].y,a[1].y);this.maxY=Math.max(a[0].y,a[1].y)}GridBounds.prototype.equals=function(a){if(this.maxX===a.maxX&&this.maxY===a.maxY&&this.minX===a.minX&&this.minY===a.minY){return true}else{return false}};GridBounds.prototype.containsPoint=function(a){var b=this;return(b.minX<=a.x&&b.maxX>=a.x&&b.minY<=a.y&&b.maxY>=a.y)};MarkerManager.prototype.getGridCellCreate_=function(x,y,z){var b=this.grid_[z];if(x<0){x+=this.gridWidth_[z]}var c=b[x];if(!c){c=b[x]=[];return(c[y]=[])}var a=c[y];if(!a){return(c[y]=[])}return a};MarkerManager.prototype.getGridCellNoCreate_=function(x,y,z){var a=this.grid_[z];if(x<0){x+=this.gridWidth_[z]}var b=a[x];return b?b[y]:undefined};MarkerManager.prototype.getGridBounds_=function(j,b,c,e){b=Math.min(b,this.maxZoom_);var i=j.getSouthWest();var f=j.getNorthEast();var d=this.getTilePoint_(i,b,c);var g=this.getTilePoint_(f,b,e);var a=this.gridWidth_[b];if(f.lng()<i.lng()||g.x<d.x){d.x-=a}if(g.x-d.x+1>=a){d.x=0;g.x=a-1}var h=new GridBounds([d,g]);h.z=b;return h};MarkerManager.prototype.getMapGridBounds_=function(){return this.getGridBounds_(this.map_.getBounds(),this.mapZoom_,this.swPadding_,this.nePadding_)};MarkerManager.prototype.onMapMoveEnd_=function(){this.objectSetTimeout_(this,this.updateMarkers_,0)};MarkerManager.prototype.objectSetTimeout_=function(b,a,c){return window.setTimeout(function(){a.call(b)},c)};MarkerManager.prototype.visible=function(){return this.show_?true:false};MarkerManager.prototype.isHidden=function(){return!this.show_};MarkerManager.prototype.show=function(){this.show_=true;this.refresh()};MarkerManager.prototype.hide=function(){this.show_=false;this.refresh()};MarkerManager.prototype.toggle=function(){this.show_=!this.show_;this.refresh()};MarkerManager.prototype.refresh=function(){if(this.shownMarkers_>0){this.processAll_(this.shownBounds_,this.removeOverlay_)}if(this.show_){this.processAll_(this.shownBounds_,this.addOverlay_)}this.notifyListeners_()};MarkerManager.prototype.updateMarkers_=function(){this.mapZoom_=this.map_.getZoom();var a=this.getMapGridBounds_();if(a.equals(this.shownBounds_)&&a.z===this.shownBounds_.z){return}if(a.z!==this.shownBounds_.z){this.processAll_(this.shownBounds_,this.removeOverlay_);if(this.show_){this.processAll_(a,this.addOverlay_)}}else{this.rectangleDiff_(this.shownBounds_,a,this.removeCellMarkers_);if(this.show_){this.rectangleDiff_(a,this.shownBounds_,this.addCellMarkers_)}}this.shownBounds_=a;this.notifyListeners_()};MarkerManager.prototype.notifyListeners_=function(){google.maps.event.trigger(this,'changed',this.shownBounds_,this.shownMarkers_)};MarkerManager.prototype.processAll_=function(b,a){for(var x=b.minX;x<=b.maxX;x++){for(var y=b.minY;y<=b.maxY;y++){this.processCellMarkers_(x,y,b.z,a)}}};MarkerManager.prototype.processCellMarkers_=function(x,y,z,a){var b=this.getGridCellNoCreate_(x,y,z);if(b){for(var i=b.length-1;i>=0;i--){a(b[i])}}};MarkerManager.prototype.removeCellMarkers_=function(x,y,z){this.processCellMarkers_(x,y,z,this.removeOverlay_)};MarkerManager.prototype.addCellMarkers_=function(x,y,z){this.processCellMarkers_(x,y,z,this.addOverlay_)};MarkerManager.prototype.rectangleDiff_=function(c,d,a){var b=this;b.rectangleDiffCoords_(c,d,function(x,y){a.apply(b,[x,y,c.z])})};MarkerManager.prototype.rectangleDiffCoords_=function(j,k,b){var f=j.minX;var a=j.minY;var d=j.maxX;var h=j.maxY;var g=k.minX;var c=k.minY;var e=k.maxX;var i=k.maxY;var x,y;for(x=f;x<=d;x++){for(y=a;y<=h&&y<c;y++){b(x,y)}for(y=Math.max(i+1,a);y<=h;y++){b(x,y)}}for(y=Math.max(a,c);y<=Math.min(h,i);y++){for(x=Math.min(d+1,g)-1;x>=f;x--){b(x,y)}for(x=Math.max(f,e+1);x<=d;x++){b(x,y)}}};MarkerManager.prototype.removeFromArray_=function(a,c,b){var d=0;for(var i=0;i<a.length;++i){if(a[i]===c||(b&&a[i]===c)){a.splice(i--,1);d++}}return d};function ProjectionHelperOverlay(b){this.setMap(b);var d=8;var c=1<<d;var a=7;this._map=b;this._zoom=-1;this._X0=this._Y0=this._X1=this._Y1=-1}ProjectionHelperOverlay.prototype=new google.maps.OverlayView();ProjectionHelperOverlay.prototype.LngToX_=function(a){return(1+a/180)};ProjectionHelperOverlay.prototype.LatToY_=function(b){var a=Math.sin(b*Math.PI/180);return(1-0.5/Math.PI*Math.log((1+a)/(1-a)))};ProjectionHelperOverlay.prototype.LatLngToPixel=function(a,d){var c=this._map;var b=this.getProjection().fromLatLngToDivPixel(a);var e={x:~~(0.5+this.LngToX_(a.lng())*(2<<(d+6))),y:~~(0.5+this.LatToY_(a.lat())*(2<<(d+6)))};return e};ProjectionHelperOverlay.prototype.draw=function(){if(!this.ready){this.ready=true;google.maps.event.trigger(this,'ready')}};";
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private final BT747Hashtable icons = JavaLibBridge.getHashtableInstance(10);
    private int previousTime = 0;
    private int previousRec = 0;

    public GPSGmapsV3HTMLFile() {
        this.numberOfPasses = 2;
    }

    @Override
    public final void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.currentFilter = 1;
        this.isWayType = true;
        this.trackDescription = "";
        this.resetTrack();
    }

    private final void resetTrack() {
        this.track.removeAll();
    }

    @Override
    public final boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            this.trackDescription = "";
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            this.isWayType = false;
            this.currentFilter = 0;
            return true;
        }
        return false;
    }

    private final String keyCode() {
        String string = this.getParamObject().getStringParam("googlemapkey");
        if (string != null && string.length() != 0) {
            return "&key=" + string;
        }
        return "";
    }

    @Override
    protected final void writeFileHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer(1700);
        stringBuffer.setLength(0);
        stringBuffer.append("<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=VML>\n<head>\n<meta name=\"viewport\" content=\"initial-scale=1.0, user-scalable=no\" /><title>");
        stringBuffer.append(string);
        stringBuffer.append("</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n<meta name=\"description\" content=\"Tracks - Generated with BT747 V2.2.1 http://www.bt747.org - powered by Google Maps\" />\n\n<script src=\"http://maps.googleapis.com/maps/api/js?v=3.16&sensor=false&libraries=geometry");
        stringBuffer.append(this.keyCode());
        stringBuffer.append("\" type=\"text/javascript\">\n</script>\n<style type=\"text/css\">\n html, body, #map\n  {\n   width: 100%;\n   height: 100%;\n  }\n body {\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-left: 0px;\n  margin-bottom: 0px;\n }\n\n</style>\n</head>\n\n<body  onresize=\"setFooter()\">\n<div id=\"map\"> </div>\n<div id=\"footer\">\n\n<form style=\"display:inline\" action=\"javascript:gotoAddr()\">\n<input type=\"submit\" value=\"");
        stringBuffer.append(I18N.i18n("Go To"));
        stringBuffer.append("\" />\n<input type=\"submit\" value=\"\" style=\"display:none\" />\n<input size=\"30\" type=\"text\" name=\"adr\" id=\"adr\" />\n</form>\n<input type=\"submit\" value=\"");
        stringBuffer.append(I18N.i18n("Init"));
        stringBuffer.append("\" onclick=\"initial()\"/><span id=\"latlon\">");
        stringBuffer.append(I18N.i18n("Click on map to get position."));
        stringBuffer.append("  </span>");
        stringBuffer.append(I18N.i18n("Tracks"));
        stringBuffer.append(": \n");
        stringBuffer.append("<script type=\"text/javascript\">");
        stringBuffer.append("function MarkerManager(c,b){var a=this;a.map_=c;a.mapZoom_=c.getZoom();a.projectionHelper_=new ProjectionHelperOverlay(c);google.maps.event.addListener(a.projectionHelper_,'ready',function(){a.projection_=this.getProjection();a.initialize(c,b)})}MarkerManager.prototype.initialize=function(d,b){var f=this;b=b||{};f.tileSize_=MarkerManager.DEFAULT_TILE_SIZE_;var h=d.mapTypes;var i=1;for(var c in h){if(h.hasOwnProperty(c)&&h.get(c)&&h.get(c).maxZoom==='number'){var g=d.mapTypes.get(c).maxZoom;if(g>i){i=g}}}f.maxZoom_=b.maxZoom||19;f.trackMarkers_=b.trackMarkers;f.show_=b.show||true;var e;if(typeof b.borderPadding==='number'){e=b.borderPadding}else{e=MarkerManager.DEFAULT_BORDER_PADDING_}f.swPadding_=new google.maps.Size(-e,e);f.nePadding_=new google.maps.Size(e,-e);f.borderPadding_=e;f.gridWidth_={};f.grid_={};f.grid_[f.maxZoom_]={};f.numMarkers_={};f.numMarkers_[f.maxZoom_]=0;google.maps.event.addListener(d,'dragend',function(){f.onMapMoveEnd_()});google.maps.event.addListener(d,'idle',function(){f.onMapMoveEnd_()});google.maps.event.addListener(d,'zoom_changed',function(){f.onMapMoveEnd_()});f.removeOverlay_=function(a){a.setMap(null);f.shownMarkers_--};f.addOverlay_=function(a){if(f.show_){a.setMap(f.map_);f.shownMarkers_++}};f.resetManager_();f.shownMarkers_=0;f.shownBounds_=f.getMapGridBounds_();google.maps.event.trigger(f,'loaded')};MarkerManager.DEFAULT_TILE_SIZE_=1024;MarkerManager.DEFAULT_BORDER_PADDING_=100;MarkerManager.MERCATOR_ZOOM_LEVEL_ZERO_RANGE=256;MarkerManager.prototype.resetManager_=function(){var a=MarkerManager.MERCATOR_ZOOM_LEVEL_ZERO_RANGE;for(var b=0;b<=this.maxZoom_;++b){this.grid_[b]={};this.numMarkers_[b]=0;this.gridWidth_[b]=Math.ceil(a/this.tileSize_);a<<=1}};MarkerManager.prototype.clearMarkers=function(){this.processAll_(this.shownBounds_,this.removeOverlay_);this.resetManager_()};MarkerManager.prototype.getTilePoint_=function(a,c,b){var d=this.projectionHelper_.LatLngToPixel(a,c);var e=new google.maps.Point(Math.floor((d.x+b.width)/this.tileSize_),Math.floor((d.y+b.height)/this.tileSize_));return e};MarkerManager.prototype.addMarkerBatch_=function(i,d,j){var f=this;var e=i.getPosition();i.MarkerManager_minZoom=d;if(this.trackMarkers_){google.maps.event.addListener(i,'changed',function(a,b,c){f.onMarkerMoved_(a,b,c)})}var h=this.getTilePoint_(e,j,new google.maps.Size(0,0,0,0));for(var g=j;g>=d;g--){var k=this.getGridCellCreate_(h.x,h.y,g);k.push(i);h.x=h.x>>1;h.y=h.y>>1}};MarkerManager.prototype.isGridPointVisible_=function(d){var b=this.shownBounds_.minY<=d.y&&d.y<=this.shownBounds_.maxY;var e=this.shownBounds_.minX;var c=e<=d.x&&d.x<=this.shownBounds_.maxX;if(!c&&e<0){var a=this.gridWidth_[this.shownBounds_.z];c=e+a<=d.x&&d.x<=a-1}return b&&c};MarkerManager.prototype.onMarkerMoved_=function(f,b,g){var c=this.maxZoom_;var a=false;var d=this.getTilePoint_(b,c,new google.maps.Size(0,0,0,0));var e=this.getTilePoint_(g,c,new google.maps.Size(0,0,0,0));while(c>=0&&(d.x!==e.x||d.y!==e.y)){var h=this.getGridCellNoCreate_(d.x,d.y,c);if(h){if(this.removeFromArray_(h,f)){this.getGridCellCreate_(e.x,e.y,c).push(f)}}if(c===this.mapZoom_){if(this.isGridPointVisible_(d)){if(!this.isGridPointVisible_(e)){this.removeOverlay_(f);a=true}}else{if(this.isGridPointVisible_(e)){this.addOverlay_(f);a=true}}}d.x=d.x>>1;d.y=d.y>>1;e.x=e.x>>1;e.y=e.y>>1;--c}if(a){this.notifyListeners_()}};MarkerManager.prototype.removeMarker=function(d){var b=this.maxZoom_;var a=false;var e=d.getPosition();var c=this.getTilePoint_(e,b,new google.maps.Size(0,0,0,0));while(b>=0){var f=this.getGridCellNoCreate_(c.x,c.y,b);if(f){this.removeFromArray_(f,d)}if(b===this.mapZoom_){if(this.isGridPointVisible_(c)){this.removeOverlay_(d);a=true}}c.x=c.x>>1;c.y=c.y>>1;--b}if(a){this.notifyListeners_()}this.numMarkers_[d.MarkerManager_minZoom]--};MarkerManager.prototype.addMarkers=function(b,a,c){var d=this.getOptMaxZoom_(c);for(var i=b.length-1;i>=0;i--){this.addMarkerBatch_(b[i],a,d)}this.numMarkers_[a]+=b.length};MarkerManager.prototype.getOptMaxZoom_=function(a){return a||this.maxZoom_};MarkerManager.prototype.getMarkerCount=function(a){var b=0;for(var z=0;z<=a;z++){b+=this.numMarkers_[z]}return b};MarkerManager.prototype.getMarker=function(c,e,d){var b=new google.maps.LatLng(c,e);var f=this.getTilePoint_(b,d,new google.maps.Size(0,0,0,0));var g=new google.maps.Marker({position:b});var a=this.getGridCellNoCreate_(f.x,f.y,d);if(a!==undefined){for(var i=0;i<a.length;i++){if(c===a[i].getPosition().lat()&&e===a[i].getPosition().lng()){g=a[i]}}}return g};MarkerManager.prototype.addMarker=function(d,a,b){var e=this.getOptMaxZoom_(b);this.addMarkerBatch_(d,a,e);var c=this.getTilePoint_(d.getPosition(),this.mapZoom_,new google.maps.Size(0,0,0,0));if(this.isGridPointVisible_(c)&&a<=this.shownBounds_.z&&this.shownBounds_.z<=e){this.addOverlay_(d);this.notifyListeners_()}this.numMarkers_[a]++};function GridBounds(a){this.minX=Math.min(a[0].x,a[1].x);this.maxX=Math.max(a[0].x,a[1].x);this.minY=Math.min(a[0].y,a[1].y);this.maxY=Math.max(a[0].y,a[1].y)}GridBounds.prototype.equals=function(a){if(this.maxX===a.maxX&&this.maxY===a.maxY&&this.minX===a.minX&&this.minY===a.minY){return true}else{return false}};GridBounds.prototype.containsPoint=function(a){var b=this;return(b.minX<=a.x&&b.maxX>=a.x&&b.minY<=a.y&&b.maxY>=a.y)};MarkerManager.prototype.getGridCellCreate_=function(x,y,z){var b=this.grid_[z];if(x<0){x+=this.gridWidth_[z]}var c=b[x];if(!c){c=b[x]=[];return(c[y]=[])}var a=c[y];if(!a){return(c[y]=[])}return a};MarkerManager.prototype.getGridCellNoCreate_=function(x,y,z){var a=this.grid_[z];if(x<0){x+=this.gridWidth_[z]}var b=a[x];return b?b[y]:undefined};MarkerManager.prototype.getGridBounds_=function(j,b,c,e){b=Math.min(b,this.maxZoom_);var i=j.getSouthWest();var f=j.getNorthEast();var d=this.getTilePoint_(i,b,c);var g=this.getTilePoint_(f,b,e);var a=this.gridWidth_[b];if(f.lng()<i.lng()||g.x<d.x){d.x-=a}if(g.x-d.x+1>=a){d.x=0;g.x=a-1}var h=new GridBounds([d,g]);h.z=b;return h};MarkerManager.prototype.getMapGridBounds_=function(){return this.getGridBounds_(this.map_.getBounds(),this.mapZoom_,this.swPadding_,this.nePadding_)};MarkerManager.prototype.onMapMoveEnd_=function(){this.objectSetTimeout_(this,this.updateMarkers_,0)};MarkerManager.prototype.objectSetTimeout_=function(b,a,c){return window.setTimeout(function(){a.call(b)},c)};MarkerManager.prototype.visible=function(){return this.show_?true:false};MarkerManager.prototype.isHidden=function(){return!this.show_};MarkerManager.prototype.show=function(){this.show_=true;this.refresh()};MarkerManager.prototype.hide=function(){this.show_=false;this.refresh()};MarkerManager.prototype.toggle=function(){this.show_=!this.show_;this.refresh()};MarkerManager.prototype.refresh=function(){if(this.shownMarkers_>0){this.processAll_(this.shownBounds_,this.removeOverlay_)}if(this.show_){this.processAll_(this.shownBounds_,this.addOverlay_)}this.notifyListeners_()};MarkerManager.prototype.updateMarkers_=function(){this.mapZoom_=this.map_.getZoom();var a=this.getMapGridBounds_();if(a.equals(this.shownBounds_)&&a.z===this.shownBounds_.z){return}if(a.z!==this.shownBounds_.z){this.processAll_(this.shownBounds_,this.removeOverlay_);if(this.show_){this.processAll_(a,this.addOverlay_)}}else{this.rectangleDiff_(this.shownBounds_,a,this.removeCellMarkers_);if(this.show_){this.rectangleDiff_(a,this.shownBounds_,this.addCellMarkers_)}}this.shownBounds_=a;this.notifyListeners_()};MarkerManager.prototype.notifyListeners_=function(){google.maps.event.trigger(this,'changed',this.shownBounds_,this.shownMarkers_)};MarkerManager.prototype.processAll_=function(b,a){for(var x=b.minX;x<=b.maxX;x++){for(var y=b.minY;y<=b.maxY;y++){this.processCellMarkers_(x,y,b.z,a)}}};MarkerManager.prototype.processCellMarkers_=function(x,y,z,a){var b=this.getGridCellNoCreate_(x,y,z);if(b){for(var i=b.length-1;i>=0;i--){a(b[i])}}};MarkerManager.prototype.removeCellMarkers_=function(x,y,z){this.processCellMarkers_(x,y,z,this.removeOverlay_)};MarkerManager.prototype.addCellMarkers_=function(x,y,z){this.processCellMarkers_(x,y,z,this.addOverlay_)};MarkerManager.prototype.rectangleDiff_=function(c,d,a){var b=this;b.rectangleDiffCoords_(c,d,function(x,y){a.apply(b,[x,y,c.z])})};MarkerManager.prototype.rectangleDiffCoords_=function(j,k,b){var f=j.minX;var a=j.minY;var d=j.maxX;var h=j.maxY;var g=k.minX;var c=k.minY;var e=k.maxX;var i=k.maxY;var x,y;for(x=f;x<=d;x++){for(y=a;y<=h&&y<c;y++){b(x,y)}for(y=Math.max(i+1,a);y<=h;y++){b(x,y)}}for(y=Math.max(a,c);y<=Math.min(h,i);y++){for(x=Math.min(d+1,g)-1;x>=f;x--){b(x,y)}for(x=Math.max(f,e+1);x<=d;x++){b(x,y)}}};MarkerManager.prototype.removeFromArray_=function(a,c,b){var d=0;for(var i=0;i<a.length;++i){if(a[i]===c||(b&&a[i]===c)){a.splice(i--,1);d++}}return d};function ProjectionHelperOverlay(b){this.setMap(b);var d=8;var c=1<<d;var a=7;this._map=b;this._zoom=-1;this._X0=this._Y0=this._X1=this._Y1=-1}ProjectionHelperOverlay.prototype=new google.maps.OverlayView();ProjectionHelperOverlay.prototype.LngToX_=function(a){return(1+a/180)};ProjectionHelperOverlay.prototype.LatToY_=function(b){var a=Math.sin(b*Math.PI/180);return(1-0.5/Math.PI*Math.log((1+a)/(1-a)))};ProjectionHelperOverlay.prototype.LatLngToPixel=function(a,d){var c=this._map;var b=this.getProjection().fromLatLngToDivPixel(a);var e={x:~~(0.5+this.LngToX_(a.lng())*(2<<(d+6))),y:~~(0.5+this.LatToY_(a.lat())*(2<<(d+6)))};return e};ProjectionHelperOverlay.prototype.draw=function(){if(!this.ready){this.ready=true;google.maps.event.trigger(this,'ready')}};");
        stringBuffer.append("</script>\n");
        stringBuffer.append("<script type=\"text/javascript\">\n");
        stringBuffer.append(" geocoder = new google.maps.Geocoder();\n preva = \"none\";\nfunction getBoundsZoomLevel(bounds, mapDim) {\n  var WORLD_DIM = { height: 256, width: 256 };\n  var ZOOM_MAX = 21;\n  function latRad(lat) {\n     var sin = Math.sin(lat * Math.PI / 180);\n    var radX2 = Math.log((1 + sin) / (1 - sin)) / 2;\n    return Math.max(Math.min(radX2, Math.PI), -Math.PI) / 2;\n  }\n  function zoom(mapPx, worldPx, fraction) {\n    return Math.floor(Math.log(mapPx / worldPx / fraction) / Math.LN2);\n  }\n  var ne = bounds.getNorthEast();\n  var sw = bounds.getSouthWest();\n  var latFraction = (latRad(ne.lat()) - latRad(sw.lat())) / Math.PI;\n  var lngDiff = ne.lng() - sw.lng();\n  var lngFraction = ((lngDiff < 0) ? (lngDiff + 360) : lngDiff) / 360;\n  var latZoom = zoom(mapDim.height, WORLD_DIM.height, latFraction);\n  var lngZoom = zoom(mapDim.width, WORLD_DIM.width, lngFraction);\n  return Math.min(latZoom, lngZoom, ZOOM_MAX);\n}\n function openInfoWindow(map,latlng,txt){\n   var infowindow = new google.maps.InfoWindow({content: txt});\n   var marker = new google.maps.Marker({\n   position: latlng,map: map});   infowindow.open(map,marker);}\n function showaddr(latlng) {\n  if (latlng) {\n   geocoder.geocode({'latLng':latlng}, function(result,status) {\n    if(status===google.maps.GeocoderStatus.OK) {\n     adr=result[0];\n     var txt=adr.formatted_address;\n     if(txt==preva) {\n      openInfoWindow(map,latlng, txt);\n     } else {\n      preva = txt;\n     }\n    }\n   });\n  }\n }\nfunction latlonTxt(latlon) {\n if(latlon) {\n  var s='<b>");
        stringBuffer.append(I18N.i18n("Last click"));
        stringBuffer.append(": '+ latlon.toUrlValue()+' </b>';\n  showaddr(latlon);  document.getElementById(\"latlon\").innerHTML = s;\n }\n}\nfunction latlonFunc() {\n return function(overlay,latlon) {latlonTxt(latlon.latLng);};\n}\nfunction gotoPt(result,status) {\n if(status!==google.maps.GeocoderStatus.OK){\n  document.getElementById(\"latlon\").innerHTML=\"");
        stringBuffer.append(I18N.i18n("Location not found"));
        stringBuffer.append("\";\n } else {\n  map.setCenter(result[0].geometry.location);latlonTxt(result[0].geometry.location);\n }\n}\n\nfunction gotoAddr(){\n var ad=document.getElementById(\"adr\").value;\n new google.maps.Geocoder().geocode({'address':ad},gotoPt);\n}\nfunction makeOpenerCaller(i) { return function() { showMarkerInfo(i); };}\nfunction showMarkerInfo(i) {\n   var infowindow = new google.maps.InfoWindow({content: infoHtmls[i]});\n   infowindow.open(map,markers[i]);\n}\nfunction getWindowHeight() {\n var windowHeight=0;\n if (typeof(window.innerHeight)=='number') {\n  windowHeight=window.innerHeight;\n } else {\n  if (document.documentElement&&document.documentElement.clientHeight) {\n  windowHeight = document.documentElement.clientHeight;\n  } else {\n   if (document.body&&document.body.clientHeight) {\n    windowHeight=document.body.clientHeight;\n   }\n  }\n }\n return windowHeight;\n}\nfunction setFooter() {\n if (document.getElementById) {\n  var windowHeight=getWindowHeight();\n  var footerElement=document.getElementById('footer');\n  var footerHeight=footerElement.offsetHeight;\n   document.getElementById('map').style.height=\n    (windowHeight-footerHeight)+'px';\n }\n}\nfunction trackClick(trk,val) {\n if (val == 1) {\n  trk.setMap(map);\n } else {\n  trk.setMap(null);\n } }\nfunction makeLatLonInfo(h) {\n return function(latlng) {\n  latlonTxt(latlng.latLng);\n  openInfoWindow(map,latlng.latLng, h);\n };\n} var clickStr; clickStr=\"\"; function clickString() {\n  document.write(clickStr);\n }\n var mapTypeIds=['OSM',google.maps.MapTypeId.ROADMAP,google.maps.MapTypeId.SATELLITE,google.maps.MapTypeId.HYBRID,google.maps.MapTypeId.TERRAIN];\n var map=new google.maps.Map(   document.getElementById(\"map\"),  {\n    center:new google.maps.LatLng(0,0)\n    ,mapTypeControl: true\n    ,mapTypeControlOptions: {mapTypeIds:mapTypeIds}    ,scaleControl:true\n    ,overviewMapControl:true\n    ,rotateControl:true\n    ,panControl:true\n    ,streetViewControl:true\n    ,zoomControl:true\n    ,mapTypeIds:mapTypeIds    ,mapTypeId:google.maps.MapTypeId.ROADMAP  });\nmap.mapTypes.set('OSM', new google.maps.ImageMapType({\n    getTileUrl: function(coord, zoom) {\n        return 'http://tile.openstreetmap.org/' + zoom + '/' + coord.x + '/' + coord.y + '.png';\n    },\n    tileSize: new google.maps.Size(256, 256),\n    name: 'OpenStreetMap',\n    maxZoom: 19\n}));\n");
        this.writeTxt(stringBuffer.toString());
    }

    @Override
    protected final void writeDataHeader() {
        if (!this.isWayType) {
            this.isNewTrack = true;
            this.minlat = 90.0;
            this.maxlat = -90.0;
            this.minlon = 180.0;
            this.maxlon = -180.0;
        }
    }

    protected final void endTrack(String string) {
        String string2 = (String)new PolylineEncoder().dpEncode(this.track).get("encodedPoints");
        if (string2.length() >= 2) {
            this.rec.setLength(0);
            this.trackOnClickFuncCalls = this.trackOnClickFuncCalls + "trackClick(track" + this.trackIndex + ",this.checked);";
            this.rec.append("var track");
            this.rec.append(this.trackIndex);
            this.rec.append("=new google.maps.Polyline({strokeColor:\"#");
            this.rec.append(string);
            this.rec.append("\",\n  strokeWeight: 4,\n  strokeOpacity: 0.8,geodesic:true,path:google.maps.geometry.encoding.decodePath(\"");
            this.rec.append(string2);
            this.rec.append("\")});\n");
            this.rec.append("track");
            this.rec.append(this.trackIndex);
            this.rec.append(".setMap(map);\n");
            this.rec.append("google.maps.event.addListener(track");
            this.rec.append(this.trackIndex);
            this.rec.append(",'click',makeLatLonInfo(\"<b>Track span</b><br/>" + this.trackStartInfo + "<br/>");
            this.rec.append("<b>#" + this.previousRec + "# </b>" + CommonOut.getDateTimeStr(this.previousTime));
            this.rec.append("\"));\n");
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
        ++this.trackIndex;
        this.resetTrack();
    }

    @Override
    protected final void writeDataFooter() {
        if (this.isWayType) {
            if (this.waypoints.size() != 0) {
                this.rec.setLength(0);
                this.rec.append("\nvar baseIcon = new google.maps.Marker();");
                BT747Hashtable bT747Hashtable = this.icons.iterator();
                while (bT747Hashtable.hasNext()) {
                    Object object = bT747Hashtable.nextKey();
                    this.rec.append("\nvar ICON");
                    this.rec.append((String)object);
                    this.rec.append("={");
                    this.rec.append("image:'");
                    this.rec.append((String)bT747Hashtable.get(object));
                    this.rec.append("'");
                    this.rec.append("};");
                }
                this.rec.append("\nvar markers;\nmarkers=[");
                for (int i = 0; i < this.waypoints.size(); ++i) {
                    this.rec.append("\nnew google.maps.Marker({");
                    if (((String)this.iconList.elementAt(i)).length() != 0) {
                        this.rec.append("icon:");
                        this.rec.append(this.iconList.elementAt(i));
                        this.rec.append(".image,");
                    }
                    this.rec.append("map:map,position:new google.maps.LatLng(");
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLatDouble(), 7));
                    this.rec.append(',');
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLonDouble(), 7));
                    this.rec.append(')');
                    this.rec.append("}),");
                }
                this.rec.setCharAt(this.rec.length() - 1, ']');
                this.rec.append(";\n infoHtmls=[\n");
                this.rec.append(this.infoHtmls.toString());
                this.rec.append("];\n");
                this.rec.append("for (var i=0; i<markers.length; ++i) {\n");
                this.rec.append("google.maps.event.addListener(markers[i],'click',makeOpenerCaller(i));\n");
                this.rec.append("}\n");
                this.rec.append("\n");
                this.writeTxt(this.rec.toString());
                this.rec.setLength(0);
                this.waypoints.removeAll();
                this.infoHtmls.setLength(0);
                this.iconList.removeAllElements();
            }
            this.resetTrack();
            return;
        }
        this.endTrack(this.goodTrackColor);
        this.splitOrEndTrack();
    }

    private final void splitOrEndTrack() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isWayType && this.trackOnClickFuncCalls.length() != 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("clickStr+= \"" + this.trackDescription + "<input type=\\\"checkbox\\\"onClick=\\\"" + this.trackOnClickFuncCalls + "\\\" checked/>\";\n");
            this.writeTxt(stringBuffer.toString());
            this.trackOnClickFuncCalls = "";
            this.trackDescription = "";
        }
    }

    @Override
    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (!this.ptFilters[this.currentFilter].doFilter(gPSRecord)) {
            if (!(this.isWayType || this.isNewTrack || this.firstRecord || this.ignoreBadPoints)) {
                this.isNewTrack = true;
                if (this.track.size() != 0) {
                    Trackpoint trackpoint = this.track.get(this.track.size() - 1);
                    this.endTrack(this.goodTrackColor);
                    this.track.addTrackpoint(trackpoint);
                    this.trackStartInfo = "<b>#" + this.previousRec + "# </b>" + CommonOut.getDateTimeStr(this.previousTime);
                }
            }
            if (!this.isWayType && this.cachedRecordIsNeeded(gPSRecord)) {
                if (gPSRecord.getLatitude() < this.minlat) {
                    this.minlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLatitude() > this.maxlat) {
                    this.maxlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLongitude() < this.minlon) {
                    this.minlon = gPSRecord.getLongitude();
                }
                if (gPSRecord.getLongitude() > this.maxlon) {
                    this.maxlon = gPSRecord.getLongitude();
                    return;
                }
            }
        } else {
            Object object;
            if (!this.isWayType) {
                this.rec.setLength(0);
                if (this.isNewTrack || this.needsToSplitTrack) {
                    this.isNewTrack = false;
                    if (gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                        if (!this.needsToSplitTrack) {
                            this.track.addTrackpoint(new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude()));
                            if (gPSRecord.hasUtc()) {
                                this.previousTime = gPSRecord.getUtc();
                                this.previousRec = gPSRecord.recCount;
                            }
                            this.endTrack(this.badTrackColor);
                        } else {
                            this.endTrack(this.goodTrackColor);
                            this.splitOrEndTrack();
                        }
                    }
                    this.resetTrack();
                    this.trackStartInfo = "<b>#" + gPSRecord.recCount + "# </b>" + CommonOut.getDateTimeStr(gPSRecord, this.t);
                    if (this.trackDescription.length() == 0) {
                        this.trackDescription = CommonOut.getDateTimeStr(gPSRecord, this.t);
                    }
                }
            }
            if (gPSRecord.hasUtc()) {
                this.previousTime = gPSRecord.getUtc();
                this.previousRec = gPSRecord.getRecCount();
            }
            if (gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                object = new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude());
                this.track.addTrackpoint((Trackpoint)object);
                if (((Trackpoint)object).getLatDouble() < this.minlat) {
                    this.minlat = ((Trackpoint)object).getLatDouble();
                }
                if (((Trackpoint)object).getLatDouble() > this.maxlat) {
                    this.maxlat = ((Trackpoint)object).getLatDouble();
                }
                if (((Trackpoint)object).getLonDouble() < this.minlon) {
                    this.minlon = ((Trackpoint)object).getLonDouble();
                }
                if (((Trackpoint)object).getLonDouble() > this.maxlon) {
                    this.maxlon = ((Trackpoint)object).getLonDouble();
                }
            }
            if (this.isWayType && gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                this.waypoints.addTrackpoint(new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude()));
                this.infoHtmls.append("\"");
                object = CommonOut.getRCRstr(gPSRecord);
                String string = "";
                if (this.icons.get(object) == null) {
                    WayPointStyle wayPointStyle = ((String)object).length() > 0 && ((String)object).charAt(0) == 'X' ? CommonOut.getWayPointStyles().get(((String)object).substring(1)) : (((String)object).length() > 1 ? CommonOut.getWayPointStyles().get("M") : CommonOut.getWayPointStyles().get((String)object));
                    if (wayPointStyle != null) {
                        string = wayPointStyle.getIconUrl();
                        this.icons.put(object, string);
                        string = "ICON" + (String)object;
                    }
                } else {
                    string = "ICON" + (String)object;
                }
                this.iconList.addElement(string);
                CommonOut.getHtml(this.infoHtmls, gPSRecord, this.selectedFileFields, this.t, this.recordNbrInLogs, this.imperial);
                this.infoHtmls.append("\",\n");
            }
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
    }

    @Override
    public final void finaliseFile() {
        if (this.isOpen()) {
            this.writeDataFooter();
            String string = "clickString();\ngoogle.maps.event.addListener(map,'click',latlonFunc());\nfunction initial() { map.setCenter(new google.maps.LatLng(" + JavaLibBridge.toString((this.maxlat + this.minlat) / 2.0) + "," + JavaLibBridge.toString((this.maxlon + this.minlon) / 2.0) + "));\nvar mapDim = document.getElementById('map').getBoundingClientRect();\n map.setZoom(\ngetBoundsZoomLevel(new google.maps.LatLngBounds(new google.maps.LatLng(" + this.minlat + ',' + this.minlon + "),new google.maps.LatLng(" + this.maxlat + ',' + this.maxlon + "))\n,mapDim)\n);\n" + "};\n setFooter();\n initial();\n\n" + "//]]>\n</script>\n </div>\n</body>\n" + "</html>";
            this.writeTxt(string);
        }
        super.finaliseFile();
    }
}

