/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceDiscovery;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LocatorRegistry;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.ProcessPrx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class LocatorRegistryI
implements LocatorRegistry {
    final ObjectPrx _wellKnownProxy;
    final Map<String, ObjectPrx> _adapters = new HashMap<String, ObjectPrx>();
    final Map<String, Set<String>> _replicaGroups = new HashMap<String, Set<String>>();

    public LocatorRegistryI(Communicator com) {
        this._wellKnownProxy = com.stringToProxy("p").ice_locator(null).ice_router(null).ice_collocationOptimized(true);
    }

    @Override
    public synchronized CompletionStage<Void> setAdapterDirectProxyAsync(String adapterId, ObjectPrx proxy, Current current) {
        if (proxy != null) {
            this._adapters.put(adapterId, proxy);
        } else {
            this._adapters.remove(adapterId);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletionStage<Void> setReplicatedAdapterDirectProxyAsync(String adapterId, String replicaGroupId, ObjectPrx proxy, Current current) {
        if (proxy != null) {
            this._adapters.put(adapterId, proxy);
            Set<String> s = this._replicaGroups.get(replicaGroupId);
            if (s == null) {
                s = new HashSet<String>();
                this._replicaGroups.put(replicaGroupId, s);
            }
            s.add(adapterId);
        } else {
            this._adapters.remove(adapterId);
            Set<String> s = this._replicaGroups.get(replicaGroupId);
            if (s != null) {
                s.remove(adapterId);
                if (s.isEmpty()) {
                    this._replicaGroups.remove(adapterId);
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<Void> setServerProcessProxyAsync(String serverId, ProcessPrx process, Current current) {
        return CompletableFuture.completedFuture(null);
    }

    synchronized ObjectPrx findObject(Identity id) {
        if (id.name.length() == 0) {
            return null;
        }
        ObjectPrx prx = this._wellKnownProxy.ice_identity(id);
        ArrayList<String> adapterIds = new ArrayList<String>();
        for (String a : this._replicaGroups.keySet()) {
            try {
                prx.ice_adapterId(a).ice_ping();
                adapterIds.add(a);
            }
            catch (LocalException localException) {}
        }
        if (adapterIds.isEmpty()) {
            for (String a : this._adapters.keySet()) {
                try {
                    prx.ice_adapterId(a).ice_ping();
                    adapterIds.add(a);
                }
                catch (LocalException localException) {}
            }
        }
        if (adapterIds.isEmpty()) {
            return null;
        }
        Collections.shuffle(adapterIds);
        return prx.ice_adapterId((String)adapterIds.get(0));
    }

    synchronized FindAdapterResult findAdapter(String adapterId) {
        FindAdapterResult r = new FindAdapterResult();
        ObjectPrx proxy = this._adapters.get(adapterId);
        if (proxy != null) {
            r.isReplicaGroup = false;
            r.returnValue = proxy;
            return r;
        }
        Set<String> s = this._replicaGroups.get(adapterId);
        if (s != null) {
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            ObjectPrx prx = null;
            for (String a : s) {
                proxy = this._adapters.get(a);
                if (proxy == null) continue;
                if (prx == null) {
                    prx = proxy;
                }
                endpoints.addAll(Arrays.asList(proxy.ice_getEndpoints()));
            }
            if (prx != null) {
                r.isReplicaGroup = true;
                r.returnValue = prx.ice_endpoints(endpoints.toArray(new Endpoint[endpoints.size()]));
                return r;
            }
        }
        r.isReplicaGroup = false;
        r.returnValue = null;
        return r;
    }

    static class FindAdapterResult {
        ObjectPrx returnValue;
        boolean isReplicaGroup;

        FindAdapterResult() {
        }
    }
}

