/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface FileIterator
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public ReadResult read(int var1, Current var2) throws FileNotAvailableException;

    public void destroy(Current var1);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return FileIterator.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::FileIterator";
    }

    public static CompletionStage<OutputStream> _iceD_read(FileIterator obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_size = istr.readInt();
        inS.endReadParams();
        ReadResult ret = obj.read(iceP_size, current);
        OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_destroy(FileIterator obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.destroy(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return FileIterator._iceD_destroy(this, in, current);
            }
            case 1: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 2: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 5: {
                return FileIterator._iceD_read(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::FileIterator"};
        _iceOps = new String[]{"destroy", "ice_id", "ice_ids", "ice_isA", "ice_ping", "read"};
    }

    public static class ReadResult {
        public boolean returnValue;
        public String[] lines;

        public ReadResult() {
        }

        public ReadResult(boolean returnValue, String[] lines) {
            this.returnValue = returnValue;
            this.lines = lines;
        }

        public void write(OutputStream ostr) {
            ostr.writeStringSeq(this.lines);
            ostr.writeBool(this.returnValue);
        }

        public void read(InputStream istr) {
            this.lines = istr.readStringSeq();
            this.returnValue = istr.readBool();
        }
    }
}

