/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deformably register two images using the demons algorithm.


DemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the displacement field which will map a moving image onto
a fixed image.

A displacement field is represented as a image whose pixel type is
some vector type with at least N elements, where N is the dimension of
the fixed image. The vector type must support element access via
operator []. It is assumed that the vector elements behave like
floating point scalars.

This class is templated over the fixed image type, moving image type
and the displacement field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial displacement field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The algorithm has one parameters: the number of iteration to be
performed.

The output displacement field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .


WARNING:
This filter assumes that the fixed image type, moving image type and
displacement field type all have the same number of dimensions.

See:
 DemonsRegistrationFunction

 itk::DemonsRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkDemonsRegistrationFilter.h
*/
public class DemonsRegistrationFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DemonsRegistrationFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DemonsRegistrationFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DemonsRegistrationFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DemonsRegistrationFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DemonsRegistrationFilter::~DemonsRegistrationFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DemonsRegistrationFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DemonsRegistrationFilter::DemonsRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DemonsRegistrationFilter() {
    this(SimpleITKJNI.new_DemonsRegistrationFilter(), true);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(VectorDouble StandardDeviations) {
    SimpleITKJNI.DemonsRegistrationFilter_setStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(StandardDeviations), StandardDeviations);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(double value) {
    SimpleITKJNI.DemonsRegistrationFilter_setStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::DemonsRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  VectorDouble getStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.DemonsRegistrationFilter_getStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.DemonsRegistrationFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::DemonsRegistrationFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.DemonsRegistrationFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.DemonsRegistrationFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::DemonsRegistrationFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.DemonsRegistrationFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetUseMovingImageGradient(bool UseMovingImageGradient)

Switch between using the fixed image and moving image gradient for
computing the displacement field updates.

*/
public  void setUseMovingImageGradient(boolean UseMovingImageGradient) {
    SimpleITKJNI.DemonsRegistrationFilter_setUseMovingImageGradient(swigCPtr, this, UseMovingImageGradient);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::UseMovingImageGradientOn()

Set the value of UseMovingImageGradient to true or false respectfully.

*/
public  void useMovingImageGradientOn() {
    SimpleITKJNI.DemonsRegistrationFilter_useMovingImageGradientOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::UseMovingImageGradientOff()
*/
public  void useMovingImageGradientOff() {
    SimpleITKJNI.DemonsRegistrationFilter_useMovingImageGradientOff(swigCPtr, this);
  }

  /**
bool itk::simple::DemonsRegistrationFilter::GetUseMovingImageGradient() const

Switch between using the fixed image and moving image gradient for
computing the displacement field updates.

*/
public  boolean getUseMovingImageGradient() {
    return SimpleITKJNI.DemonsRegistrationFilter_getUseMovingImageGradient(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  void setSmoothDisplacementField(boolean SmoothDisplacementField) {
    SimpleITKJNI.DemonsRegistrationFilter_setSmoothDisplacementField(swigCPtr, this, SmoothDisplacementField);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public  void smoothDisplacementFieldOn() {
    SimpleITKJNI.DemonsRegistrationFilter_smoothDisplacementFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SmoothDisplacementFieldOff()
*/
public  void smoothDisplacementFieldOff() {
    SimpleITKJNI.DemonsRegistrationFilter_smoothDisplacementFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::DemonsRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  boolean getSmoothDisplacementField() {
    return SimpleITKJNI.DemonsRegistrationFilter_getSmoothDisplacementField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  void setSmoothUpdateField(boolean SmoothUpdateField) {
    SimpleITKJNI.DemonsRegistrationFilter_setSmoothUpdateField(swigCPtr, this, SmoothUpdateField);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public  void smoothUpdateFieldOn() {
    SimpleITKJNI.DemonsRegistrationFilter_smoothUpdateFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SmoothUpdateFieldOff()
*/
public  void smoothUpdateFieldOff() {
    SimpleITKJNI.DemonsRegistrationFilter_smoothUpdateFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::DemonsRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  boolean getSmoothUpdateField() {
    return SimpleITKJNI.DemonsRegistrationFilter_getSmoothUpdateField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(VectorDouble UpdateFieldStandardDeviations) {
    SimpleITKJNI.DemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(UpdateFieldStandardDeviations), UpdateFieldStandardDeviations);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(double value) {
    SimpleITKJNI.DemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::DemonsRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  VectorDouble getUpdateFieldStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.DemonsRegistrationFilter_getUpdateFieldStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public  void setMaximumKernelWidth(long MaximumKernelWidth) {
    SimpleITKJNI.DemonsRegistrationFilter_setMaximumKernelWidth(swigCPtr, this, MaximumKernelWidth);
  }

  /**
unsigned int itk::simple::DemonsRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public  long getMaximumKernelWidth() {
    return SimpleITKJNI.DemonsRegistrationFilter_getMaximumKernelWidth(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  void setMaximumError(double MaximumError) {
    SimpleITKJNI.DemonsRegistrationFilter_setMaximumError(swigCPtr, this, MaximumError);
  }

  /**
double itk::simple::DemonsRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  double getMaximumError() {
    return SimpleITKJNI.DemonsRegistrationFilter_getMaximumError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public  void setIntensityDifferenceThreshold(double IntensityDifferenceThreshold) {
    SimpleITKJNI.DemonsRegistrationFilter_setIntensityDifferenceThreshold(swigCPtr, this, IntensityDifferenceThreshold);
  }

  /**
double itk::simple::DemonsRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public  double getIntensityDifferenceThreshold() {
    return SimpleITKJNI.DemonsRegistrationFilter_getIntensityDifferenceThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.DemonsRegistrationFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.DemonsRegistrationFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DemonsRegistrationFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.DemonsRegistrationFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::DemonsRegistrationFilter::GetUseImageSpacing() const
*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.DemonsRegistrationFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
uint32_t itk::simple::DemonsRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.DemonsRegistrationFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::DemonsRegistrationFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.DemonsRegistrationFilter_getRMSChange(swigCPtr, this);
  }

  /**
double itk::simple::DemonsRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the overlapping region between the two images. This is
value is only available for the previous iteration and NOT the current
iteration.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMetric() {
    return SimpleITKJNI.DemonsRegistrationFilter_getMetric(swigCPtr, this);
  }

  /**
void itk::simple::DemonsRegistrationFilter::StopRegistration()

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  void stopRegistration() {
    SimpleITKJNI.DemonsRegistrationFilter_stopRegistration(swigCPtr, this);
  }

  /**
std::string itk::simple::DemonsRegistrationFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DemonsRegistrationFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DemonsRegistrationFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DemonsRegistrationFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage, Image initialDisplacementField) {
    return new Image(SimpleITKJNI.DemonsRegistrationFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(initialDisplacementField), initialDisplacementField), true);
  }

  /**
Image itk::simple::DemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage) {
    return new Image(SimpleITKJNI.DemonsRegistrationFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage), true);
  }

}
