// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe_transactions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// StartSpoeTransactionCreatedCode is the HTTP code returned for type StartSpoeTransactionCreated
const StartSpoeTransactionCreatedCode int = 201

/*
StartSpoeTransactionCreated Transaction started

swagger:response startSpoeTransactionCreated
*/
type StartSpoeTransactionCreated struct {

	/*
	  In: Body
	*/
	Payload *models.SpoeTransaction `json:"body,omitempty"`
}

// NewStartSpoeTransactionCreated creates StartSpoeTransactionCreated with default headers values
func NewStartSpoeTransactionCreated() *StartSpoeTransactionCreated {

	return &StartSpoeTransactionCreated{}
}

// WithPayload adds the payload to the start spoe transaction created response
func (o *StartSpoeTransactionCreated) WithPayload(payload *models.SpoeTransaction) *StartSpoeTransactionCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the start spoe transaction created response
func (o *StartSpoeTransactionCreated) SetPayload(payload *models.SpoeTransaction) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *StartSpoeTransactionCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// StartSpoeTransactionTooManyRequestsCode is the HTTP code returned for type StartSpoeTransactionTooManyRequests
const StartSpoeTransactionTooManyRequestsCode int = 429

/*
StartSpoeTransactionTooManyRequests Too many open transactions

swagger:response startSpoeTransactionTooManyRequests
*/
type StartSpoeTransactionTooManyRequests struct {

	/*
	  In: Body
	*/
	Payload *StartSpoeTransactionTooManyRequestsBody `json:"body,omitempty"`
}

// NewStartSpoeTransactionTooManyRequests creates StartSpoeTransactionTooManyRequests with default headers values
func NewStartSpoeTransactionTooManyRequests() *StartSpoeTransactionTooManyRequests {

	return &StartSpoeTransactionTooManyRequests{}
}

// WithPayload adds the payload to the start spoe transaction too many requests response
func (o *StartSpoeTransactionTooManyRequests) WithPayload(payload *StartSpoeTransactionTooManyRequestsBody) *StartSpoeTransactionTooManyRequests {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the start spoe transaction too many requests response
func (o *StartSpoeTransactionTooManyRequests) SetPayload(payload *StartSpoeTransactionTooManyRequestsBody) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *StartSpoeTransactionTooManyRequests) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(429)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
StartSpoeTransactionDefault General Error

swagger:response startSpoeTransactionDefault
*/
type StartSpoeTransactionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewStartSpoeTransactionDefault creates StartSpoeTransactionDefault with default headers values
func NewStartSpoeTransactionDefault(code int) *StartSpoeTransactionDefault {
	if code <= 0 {
		code = 500
	}

	return &StartSpoeTransactionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the start spoe transaction default response
func (o *StartSpoeTransactionDefault) WithStatusCode(code int) *StartSpoeTransactionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the start spoe transaction default response
func (o *StartSpoeTransactionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the start spoe transaction default response
func (o *StartSpoeTransactionDefault) WithConfigurationVersion(configurationVersion string) *StartSpoeTransactionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the start spoe transaction default response
func (o *StartSpoeTransactionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the start spoe transaction default response
func (o *StartSpoeTransactionDefault) WithPayload(payload *models.Error) *StartSpoeTransactionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the start spoe transaction default response
func (o *StartSpoeTransactionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *StartSpoeTransactionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
