// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPResponseRuleBackendOKCode is the HTTP code returned for type GetAllHTTPResponseRuleBackendOK
const GetAllHTTPResponseRuleBackendOKCode int = 200

/*
GetAllHTTPResponseRuleBackendOK Successful operation

swagger:response getAllHttpResponseRuleBackendOK
*/
type GetAllHTTPResponseRuleBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPResponseRules `json:"body,omitempty"`
}

// NewGetAllHTTPResponseRuleBackendOK creates GetAllHTTPResponseRuleBackendOK with default headers values
func NewGetAllHTTPResponseRuleBackendOK() *GetAllHTTPResponseRuleBackendOK {

	return &GetAllHTTPResponseRuleBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http response rule backend o k response
func (o *GetAllHTTPResponseRuleBackendOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPResponseRuleBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http response rule backend o k response
func (o *GetAllHTTPResponseRuleBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http response rule backend o k response
func (o *GetAllHTTPResponseRuleBackendOK) WithPayload(payload models.HTTPResponseRules) *GetAllHTTPResponseRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http response rule backend o k response
func (o *GetAllHTTPResponseRuleBackendOK) SetPayload(payload models.HTTPResponseRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPResponseRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPResponseRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPResponseRuleBackendDefault General Error

swagger:response getAllHttpResponseRuleBackendDefault
*/
type GetAllHTTPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPResponseRuleBackendDefault creates GetAllHTTPResponseRuleBackendDefault with default headers values
func NewGetAllHTTPResponseRuleBackendDefault(code int) *GetAllHTTPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP response rule backend default response
func (o *GetAllHTTPResponseRuleBackendDefault) WithStatusCode(code int) *GetAllHTTPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP response rule backend default response
func (o *GetAllHTTPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP response rule backend default response
func (o *GetAllHTTPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP response rule backend default response
func (o *GetAllHTTPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP response rule backend default response
func (o *GetAllHTTPResponseRuleBackendDefault) WithPayload(payload *models.Error) *GetAllHTTPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP response rule backend default response
func (o *GetAllHTTPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
