# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class InstanceViewTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    INSTANCE_VIEW = "instanceView"

class PublicNetworkAccessType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The network access policy to determine if Azure Arc agents can use public Azure Arc service
    endpoints. Defaults to disabled (access to Azure Arc services only via private link).
    """

    #: Allows Azure Arc agents to communicate with Azure Arc services over both public (internet) and
    #: private endpoints.
    ENABLED = "Enabled"
    #: Does not allow Azure Arc agents to communicate with Azure Arc services over public (internet)
    #: endpoints. The agents must use the private link.
    DISABLED = "Disabled"

class StatusLevelTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The level code.
    """

    INFO = "Info"
    WARNING = "Warning"
    ERROR = "Error"

class StatusTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the hybrid machine agent.
    """

    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    ERROR = "Error"
