# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class DiagnosticSettingsCategoryResource(ProxyOnlyResource):
    """The diagnostic settings category resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param category_type: The type of the diagnostic settings category.
     Possible values include: 'Metrics', 'Logs'
    :type category_type: str or ~azure.mgmt.monitor.models.CategoryType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'category_type': {'key': 'properties.categoryType', 'type': 'CategoryType'},
    }

    def __init__(self, **kwargs):
        super(DiagnosticSettingsCategoryResource, self).__init__(**kwargs)
        self.category_type = kwargs.get('category_type', None)
