# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SearchMetadata(Model):
    """Metadata for search results.

    :param search_id: The request id of the search.
    :type search_id: str
    :param result_type: The search result type.
    :type result_type: str
    :param total: The total number of search results.
    :type total: long
    :param top: The number of top search results.
    :type top: long
    :param id: The id of the search results request.
    :type id: str
    :param core_summaries: The core summaries.
    :type core_summaries: list[~azure.mgmt.loganalytics.models.CoreSummary]
    :param status: The status of the search results.
    :type status: str
    :param start_time: The start time for the search.
    :type start_time: datetime
    :param last_updated: The time of last update.
    :type last_updated: datetime
    :param e_tag: The ETag of the search results.
    :type e_tag: str
    :param sort: How the results are sorted.
    :type sort: list[~azure.mgmt.loganalytics.models.SearchSort]
    :param request_time: The request time.
    :type request_time: long
    :param aggregated_value_field: The aggregated value field.
    :type aggregated_value_field: str
    :param aggregated_grouping_fields: The aggregated grouping fields.
    :type aggregated_grouping_fields: str
    :param sum: The sum of all aggregates returned in the result set.
    :type sum: long
    :param max: The max of all aggregates returned in the result set.
    :type max: long
    :param schema: The schema.
    :type schema: ~azure.mgmt.loganalytics.models.SearchMetadataSchema
    """

    _attribute_map = {
        'search_id': {'key': 'requestId', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'total': {'key': 'total', 'type': 'long'},
        'top': {'key': 'top', 'type': 'long'},
        'id': {'key': 'id', 'type': 'str'},
        'core_summaries': {'key': 'coreSummaries', 'type': '[CoreSummary]'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'sort': {'key': 'sort', 'type': '[SearchSort]'},
        'request_time': {'key': 'requestTime', 'type': 'long'},
        'aggregated_value_field': {'key': 'aggregatedValueField', 'type': 'str'},
        'aggregated_grouping_fields': {'key': 'aggregatedGroupingFields', 'type': 'str'},
        'sum': {'key': 'sum', 'type': 'long'},
        'max': {'key': 'max', 'type': 'long'},
        'schema': {'key': 'schema', 'type': 'SearchMetadataSchema'},
    }

    def __init__(self, *, search_id: str=None, result_type: str=None, total: int=None, top: int=None, id: str=None, core_summaries=None, status: str=None, start_time=None, last_updated=None, e_tag: str=None, sort=None, request_time: int=None, aggregated_value_field: str=None, aggregated_grouping_fields: str=None, sum: int=None, max: int=None, schema=None, **kwargs) -> None:
        super(SearchMetadata, self).__init__(**kwargs)
        self.search_id = search_id
        self.result_type = result_type
        self.total = total
        self.top = top
        self.id = id
        self.core_summaries = core_summaries
        self.status = status
        self.start_time = start_time
        self.last_updated = last_updated
        self.e_tag = e_tag
        self.sort = sort
        self.request_time = request_time
        self.aggregated_value_field = aggregated_value_field
        self.aggregated_grouping_fields = aggregated_grouping_fields
        self.sum = sum
        self.max = max
        self.schema = schema
