# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GetProjectDetailsNonSqlTaskInput(Model):
    """Input for the task that reads configuration from project artifacts.

    All required parameters must be populated in order to send to Azure.

    :param project_name: Required. Name of the migration project
    :type project_name: str
    :param project_location: Required. A URL that points to the location to
     access project artifacts
    :type project_location: str
    """

    _validation = {
        'project_name': {'required': True},
        'project_location': {'required': True},
    }

    _attribute_map = {
        'project_name': {'key': 'projectName', 'type': 'str'},
        'project_location': {'key': 'projectLocation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GetProjectDetailsNonSqlTaskInput, self).__init__(**kwargs)
        self.project_name = kwargs.get('project_name', None)
        self.project_location = kwargs.get('project_location', None)
