<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Redirect to new-game.xslt

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:output method='html'/>

  <xsl:param name='name'/>
  <xsl:param name='diff'/>
  <xsl:param name='type'/>

  <xsl:template match='/'>

    <xsl:variable name='base-uri' select='concat("/cribbage?xslt=redirect.xsl&amp;message=",exslt-str:encode-uri("Shuffling a new deck of cards", true()))'/>
    <xsl:variable name='redirect' select='concat("redirect=",exslt-str:encode-uri(concat("/cribbage?xslt=new-game.xslt&amp;name=",$name,"&amp;diff=",$diff,"&amp;type=",$type), false()))'/>

    <fhttp:response-uri uri="{concat($base-uri,'&amp;',$redirect)}"/>
  </xsl:template>



</xsl:stylesheet>
