<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    End-of-game processing

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:include href='draw-screen.xsl'/>

  <xsl:template match="/cribbage">
    <xsl:call-template name='draw-screen'>
      <xsl:with-param name='form-action' select='""'/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name='playing-area'>
    <xsl:param name='curDealer'/>
    <!-- Play info -->

    <H1><xsl:text>Game Over</xsl:text></H1>
    <h2>
      <xsl:choose>
        <xsl:when test='/cribbage/game-info/@type="normal"'>
          <xsl:value-of select='/cribbage/player-info/player[sum(scores/score) &gt; 120]/name'/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select='/cribbage/player-info/player[sum(scores/score) &lt; 120]/name'/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> is the winner</xsl:text>
    </h2>
    <p>
      <a href='/cribbage/index.html'>Play Again?</a>
    </p>
  </xsl:template>

  <xsl:template match='Card' mode='player-hand'/>

  <xsl:template match='Card' mode='cut-card'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        <IMG src='{@img}'/>
      </TD>
    </TR>
  </xsl:template>


  <xsl:template name='cur-count'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        Current Count: <xsl:value-of select='sum(/cribbage/game-info/cur-count/score)'/>
      </TD>
    </TR>
  </xsl:template>

  <xsl:template name='player-hand-other'/>

</xsl:stylesheet>
