########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Rdf/__init__.py,v 1.8 2004/08/20 21:11:02 mbrown Exp $
"""
Implementation of '4ss rdf' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command allows one to perform basic operations on \
the 4Suite RDF model. It requires a subcommand specifying what \
operation is desired. See the help message for each subcommand for \
specific usage info."""

# command modules to register as subcommands
import Add, Complete, Remove, Versa

g_subCommands = [
    Add,
    Complete,
    Remove,
    Versa,
    ]


def Register():
    from Ft.Lib.CommandLine import Options, Command
    sc = map(lambda x:x.Register(), g_subCommands)
    cmd = Command.Command('rdf', "Perform basic operations on an RDF model in a repository",
                          None, __doc__,
                          subCommands=sc,
                          fileName = __file__)
    return cmd
