/* gcwmodule - Python wrapper for the gcw driver

  Copyright (C) 2004, 2005 Thomas J. Duck
  All rights reserved.

  Thomas J. Duck <tom.duck@dal.ca>
  Department of Physics and Atmospheric Science,
  Dalhousie University, Halifax, Nova Scotia, Canada, B3H 3J5


NOTICE

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
  USA 
*/

#include <pygobject.h>

#define PY_ARRAY_UNIQUE_SYMBOL gcwapi
#include "arrayobject.h"
 
void gcw_register_classes (PyObject *d); 
extern PyMethodDef gcw_functions[];
 
DL_EXPORT(void)
initgcw(void)
{
    PyObject *m, *d;
 
    init_pygobject ();
 
    m = Py_InitModule ("gcw",gcw_functions);
    d = PyModule_GetDict (m);
 
    gcw_register_classes (d);

    import_array();
 
    if (PyErr_Occurred ()) {
        Py_FatalError ("can't initialise module gcw");
    }
}
