/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.math.*;

public class ClientResultSetSapDB
    implements ResultSet
{
    private ResultSet             originalResultSet;
    private ClientConnectionSapDB clientConnection;
    private Statement             clientStatement;
    
    public ClientResultSetSapDB(ResultSet originalResultSet,
                                ClientConnectionSapDB clientConnection,
                                Statement clientStatement)
    {
        this.originalResultSet=originalResultSet;
        this.clientConnection=clientConnection;
        this.clientStatement=clientStatement;
    }

    private void exceptionOccurred(SQLException sqlEx) 
    {
        this.clientConnection.exceptionOccurred(sqlEx);
    }
    
    // Code for delegation of java.sql.ResultSet methods to originalResultSet

    public Object getObject(int param1, Map param2) throws SQLException
    {
        try {
            return originalResultSet.getObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Object getObject(String param1) throws SQLException
    {
        try {
            return originalResultSet.getObject(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Object getObject(int param1) throws SQLException
    {
        try {
            return originalResultSet.getObject(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Object getObject(String param1, Map param2) throws SQLException
    {
        try {
            return originalResultSet.getObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getBoolean(String param1) throws SQLException
    {
        try {
            return originalResultSet.getBoolean(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getBoolean(int param1) throws SQLException
    {
        try {
            return originalResultSet.getBoolean(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte getByte(int param1) throws SQLException
    {
        try {
            return originalResultSet.getByte(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte getByte(String param1) throws SQLException
    {
        try {
            return originalResultSet.getByte(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public short getShort(String param1) throws SQLException
    {
        try {
            return originalResultSet.getShort(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public short getShort(int param1) throws SQLException
    {
        try {
            return originalResultSet.getShort(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getInt(int param1) throws SQLException
    {
        try {
            return originalResultSet.getInt(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getInt(String param1) throws SQLException
    {
        try {
            return originalResultSet.getInt(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public long getLong(int param1) throws SQLException
    {
        try {
            return originalResultSet.getLong(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public long getLong(String param1) throws SQLException
    {
        try {
            return originalResultSet.getLong(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public float getFloat(int param1) throws SQLException
    {
        try {
            return originalResultSet.getFloat(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public float getFloat(String param1) throws SQLException
    {
        try {
            return originalResultSet.getFloat(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public double getDouble(int param1) throws SQLException
    {
        try {
            return originalResultSet.getDouble(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public double getDouble(String param1) throws SQLException
    {
        try {
            return originalResultSet.getDouble(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte[] getBytes(String param1) throws SQLException
    {
        try {
            return originalResultSet.getBytes(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte[] getBytes(int param1) throws SQLException
    {
        try {
            return originalResultSet.getBytes(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean next() throws SQLException
    {
        try {
            return originalResultSet.next();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public URL getURL(int param1) throws SQLException
    {
        try {
            return originalResultSet.getURL(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public URL getURL(String param1) throws SQLException
    {
        try {
            return originalResultSet.getURL(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getType() throws SQLException
    {
        try {
            return originalResultSet.getType();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean previous() throws SQLException
    {
        try {
            return originalResultSet.previous();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void close() throws SQLException
    {
        try {
            originalResultSet.close();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getString(String param1) throws SQLException
    {
        try {
            return originalResultSet.getString(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getString(int param1) throws SQLException
    {
        try {
            return originalResultSet.getString(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Ref getRef(int param1) throws SQLException
    {
        try {
            return originalResultSet.getRef(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Ref getRef(String param1) throws SQLException
    {
        try {
            return originalResultSet.getRef(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(int param1) throws SQLException
    {
        try {
            return originalResultSet.getTime(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(int param1, Calendar param2) throws SQLException
    {
        try {
            return originalResultSet.getTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(String param1) throws SQLException
    {
        try {
            return originalResultSet.getTime(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(String param1, Calendar param2) throws SQLException
    {
        try {
            return originalResultSet.getTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public java.sql.Date getDate(int param1) throws SQLException
    {
        try {
            return originalResultSet.getDate(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public java.sql.Date getDate(String param1, Calendar param2) throws SQLException
    {
        try {
            return originalResultSet.getDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public java.sql.Date getDate(String param1) throws SQLException
    {
        try {
            return originalResultSet.getDate(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public java.sql.Date getDate(int param1, Calendar param2) throws SQLException
    {
        try {
            return originalResultSet.getDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean first() throws SQLException
    {
        try {
            return originalResultSet.first();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException
    {
        try {
            ResultSetMetaData rsmd= originalResultSet.getMetaData();
            return rsmd==null ? null : new ClientResultSetMetaDataSapDB(rsmd, clientConnection);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public SQLWarning getWarnings() throws SQLException
    {
        try {
            return originalResultSet.getWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void clearWarnings() throws SQLException
    {
        try {
            originalResultSet.clearWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchDirection(int param1) throws SQLException
    {
        try {
            originalResultSet.setFetchDirection(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchDirection() throws SQLException
    {
        try {
            return originalResultSet.getFetchDirection();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchSize(int param1) throws SQLException
    {
        try {
            originalResultSet.setFetchSize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchSize() throws SQLException
    {
        try {
            return originalResultSet.getFetchSize();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean wasNull() throws SQLException
    {
        try {
            return originalResultSet.wasNull();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public BigDecimal getBigDecimal(String param1, int param2) throws SQLException
    {
        try {
            return originalResultSet.getBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public BigDecimal getBigDecimal(int param1) throws SQLException
    {
        try {
            return originalResultSet.getBigDecimal(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public BigDecimal getBigDecimal(int param1, int param2) throws SQLException
    {
        try {
            return originalResultSet.getBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public BigDecimal getBigDecimal(String param1) throws SQLException
    {
        try {
            return originalResultSet.getBigDecimal(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(int param1) throws SQLException
    {
        try {
            return originalResultSet.getTimestamp(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(String param1, Calendar param2) throws SQLException
    {
        try {
            return originalResultSet.getTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(String param1) throws SQLException
    {
        try {
            return originalResultSet.getTimestamp(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(int param1, Calendar param2) throws SQLException
    {
        try {
            return originalResultSet.getTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Blob getBlob(int param1) throws SQLException
    {
        try {
            return originalResultSet.getBlob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Blob getBlob(String param1) throws SQLException
    {
        try {
            return originalResultSet.getBlob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Clob getClob(int param1) throws SQLException
    {
        try {
            return originalResultSet.getClob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Clob getClob(String param1) throws SQLException
    {
        try {
            return originalResultSet.getClob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Array getArray(String param1) throws SQLException
    {
        try {
            return originalResultSet.getArray(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Array getArray(int param1) throws SQLException
    {
        try {
            return originalResultSet.getArray(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public InputStream getAsciiStream(String param1) throws SQLException
    {
        try {
            return originalResultSet.getAsciiStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public InputStream getAsciiStream(int param1) throws SQLException
    {
        try {
            return originalResultSet.getAsciiStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public InputStream getUnicodeStream(String param1) throws SQLException
    {
        try {
            return originalResultSet.getUnicodeStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public InputStream getUnicodeStream(int param1) throws SQLException
    {
        try {
            return originalResultSet.getUnicodeStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public InputStream getBinaryStream(int param1) throws SQLException
    {
        try {
            return originalResultSet.getBinaryStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public InputStream getBinaryStream(String param1) throws SQLException
    {
        try {
            return originalResultSet.getBinaryStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getCursorName() throws SQLException
    {
        try {
            return originalResultSet.getCursorName();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int findColumn(String param1) throws SQLException
    {
        try {
            return originalResultSet.findColumn(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Reader getCharacterStream(String param1) throws SQLException
    {
        try {
            return originalResultSet.getCharacterStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Reader getCharacterStream(int param1) throws SQLException
    {
        try {
            return originalResultSet.getCharacterStream(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isBeforeFirst() throws SQLException
    {
        try {
            return originalResultSet.isBeforeFirst();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isAfterLast() throws SQLException
    {
        try {
            return originalResultSet.isAfterLast();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isFirst() throws SQLException
    {
        try {
            return originalResultSet.isFirst();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isLast() throws SQLException
    {
        try {
            return originalResultSet.isLast();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void beforeFirst() throws SQLException
    {
        try {
            originalResultSet.beforeFirst();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void afterLast() throws SQLException
    {
        try {
            originalResultSet.afterLast();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean last() throws SQLException
    {
        try {
            return originalResultSet.last();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getRow() throws SQLException
    {
        try {
            return originalResultSet.getRow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean absolute(int param1) throws SQLException
    {
        try {
            return originalResultSet.absolute(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean relative(int param1) throws SQLException
    {
        try {
            return originalResultSet.relative(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getConcurrency() throws SQLException
    {
        try {
            return originalResultSet.getConcurrency();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean rowUpdated() throws SQLException
    {
        try {
            return originalResultSet.rowUpdated();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean rowInserted() throws SQLException
    {
        try {
            return originalResultSet.rowInserted();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean rowDeleted() throws SQLException
    {
        try {
            return originalResultSet.rowDeleted();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateNull(int param1) throws SQLException
    {
        try {
            originalResultSet.updateNull(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateNull(String param1) throws SQLException
    {
        try {
            originalResultSet.updateNull(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBoolean(int param1, boolean param2) throws SQLException
    {
        try {
            originalResultSet.updateBoolean(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBoolean(String param1, boolean param2) throws SQLException
    {
        try {
            originalResultSet.updateBoolean(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateByte(String param1, byte param2) throws SQLException
    {
        try {
            originalResultSet.updateByte(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateByte(int param1, byte param2) throws SQLException
    {
        try {
            originalResultSet.updateByte(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateShort(String param1, short param2) throws SQLException
    {
        try {
            originalResultSet.updateShort(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateShort(int param1, short param2) throws SQLException
    {
        try {
            originalResultSet.updateShort(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateInt(int param1, int param2) throws SQLException
    {
        try {
            originalResultSet.updateInt(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateInt(String param1, int param2) throws SQLException
    {
        try {
            originalResultSet.updateInt(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateLong(String param1, long param2) throws SQLException
    {
        try {
            originalResultSet.updateLong(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateLong(int param1, long param2) throws SQLException
    {
        try {
            originalResultSet.updateLong(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateFloat(int param1, float param2) throws SQLException
    {
        try {
            originalResultSet.updateFloat(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateFloat(String param1, float param2) throws SQLException
    {
        try {
            originalResultSet.updateFloat(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateDouble(int param1, double param2) throws SQLException
    {
        try {
            originalResultSet.updateDouble(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateDouble(String param1, double param2) throws SQLException
    {
        try {
            originalResultSet.updateDouble(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBigDecimal(int param1, BigDecimal param2) throws SQLException
    {
        try {
            originalResultSet.updateBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBigDecimal(String param1, BigDecimal param2) throws SQLException
    {
        try {
            originalResultSet.updateBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateString(int param1, String param2) throws SQLException
    {
        try {
            originalResultSet.updateString(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateString(String param1, String param2) throws SQLException
    {
        try {
            originalResultSet.updateString(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBytes(int param1, byte[] param2) throws SQLException
    {
        try {
            originalResultSet.updateBytes(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBytes(String param1, byte[] param2) throws SQLException
    {
        try {
            originalResultSet.updateBytes(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateDate(int param1, java.sql.Date param2) throws SQLException
    {
        try {
            originalResultSet.updateDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateDate(String param1, java.sql.Date param2) throws SQLException
    {
        try {
            originalResultSet.updateDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateTime(String param1, Time param2) throws SQLException
    {
        try {
            originalResultSet.updateTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateTime(int param1, Time param2) throws SQLException
    {
        try {
            originalResultSet.updateTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateTimestamp(String param1, Timestamp param2) throws SQLException
    {
        try {
            originalResultSet.updateTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateTimestamp(int param1, Timestamp param2) throws SQLException
    {
        try {
            originalResultSet.updateTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateAsciiStream(String param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateAsciiStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateAsciiStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateAsciiStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBinaryStream(String param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateBinaryStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBinaryStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateBinaryStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateCharacterStream(String param1, Reader param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateCharacterStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateCharacterStream(int param1, Reader param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateCharacterStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateObject(String param1, Object param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateObject(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateObject(String param1, Object param2) throws SQLException
    {
        try {
            originalResultSet.updateObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateObject(int param1, Object param2, int param3) throws SQLException
    {
        try {
            originalResultSet.updateObject(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateObject(int param1, Object param2) throws SQLException
    {
        try {
            originalResultSet.updateObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void insertRow() throws SQLException
    {
        try {
            originalResultSet.insertRow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateRow() throws SQLException
    {
        try {
            originalResultSet.updateRow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void deleteRow() throws SQLException
    {
        try {
            originalResultSet.deleteRow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void refreshRow() throws SQLException
    {
        try {
            originalResultSet.refreshRow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void cancelRowUpdates() throws SQLException
    {
        try {
            originalResultSet.cancelRowUpdates();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void moveToInsertRow() throws SQLException
    {
        try {
            originalResultSet.moveToInsertRow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void moveToCurrentRow() throws SQLException
    {
        try {
            originalResultSet.moveToCurrentRow();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Statement getStatement() throws SQLException
    {
        return clientStatement;
    }

    public void updateRef(int param1, Ref param2) throws SQLException
    {
        try {
            originalResultSet.updateRef(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateRef(String param1, Ref param2) throws SQLException
    {
        try {
            originalResultSet.updateRef(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBlob(String param1, Blob param2) throws SQLException
    {
        try {
            originalResultSet.updateBlob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateBlob(int param1, Blob param2) throws SQLException
    {
        try {
            originalResultSet.updateBlob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateClob(String param1, Clob param2) throws SQLException
    {
        try {
            originalResultSet.updateClob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateClob(int param1, Clob param2) throws SQLException
    {
        try {
            originalResultSet.updateClob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateArray(String param1, Array param2) throws SQLException
    {
        try {
            originalResultSet.updateArray(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void updateArray(int param1, Array param2) throws SQLException
    {
        try {
            originalResultSet.updateArray(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

}
