/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.sql.*;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.util.*;
import com.sap.dbtech.jdbc.exceptions.*;

/**
 *
 */
public class GetvalUnicodeClob
    extends GetvalUnicode
    implements java.sql.Clob
{
    /**
     * creates a new GetvalUnicodeClob
     */
    public
    GetvalUnicodeClob (
        ConnectionSapDB connection,
        byte [] descriptor,
        StructuredMem dataPart,
        boolean isUnicodeColumn,
        boolean isPacketEncodingUnicode)
    {
        super (connection, descriptor, dataPart, isUnicodeColumn, isPacketEncodingUnicode);
    }

    public String getSubString (long pos, int length)
         throws SQLException
    {
        char [] result;
        int charsRead = length;
        pos = pos - 1; // Lobs start at 1
        try {
            if (pos < this.longPosition) {
                throw new NotSupportedException(MessageTranslator.translate(MessageKey.ERROR_MOVEBACKWARDINBLOB));
            }
            java.io.Reader stream = this.getCharacterStream ();
            if (pos > this.longPosition) {
                stream.skip(pos - this.longPosition);
            }
            result = new char [length];
            charsRead = stream.read (result, 0, length);
        }
        catch (StreamIOException sioExc) {
            throw sioExc.getSqlException();
        }
        catch (java.io.IOException ioExc) {
            throw new JDBCDriverException (ioExc.getMessage());
        }
        return new String(result,0,charsRead);
    }
}
