/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.j2ee.ddloaders.multiview.ui;

import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;

import javax.swing.*;

/**
 * @author pfiala
 */
public class SessionOverviewForm extends SectionNodeInnerPanel {

    static final String SESSION_TYPE_STATELESS="Stateless"; //NOI18N
    static final String SESSION_TYPE_STATEFUL="Stateful"; //NOI18N
    static final String TRANSACTION_TYPE_BEAN="Bean"; //NOI18N
    static final String TRANSACTION_TYPE_CONTAINER="Container"; //NOI18N

    /**
     * Creates new form SessionOverviewForm
     */
    public SessionOverviewForm(SectionNodeView sectionNodeView) {
        super(sectionNodeView);
        initComponents();
        statelessRadioButton.putClientProperty(Refreshable.PROPERTY_FIXED_VALUE, SESSION_TYPE_STATELESS);
        statefulRadioButton.putClientProperty(Refreshable.PROPERTY_FIXED_VALUE, SESSION_TYPE_STATEFUL);
        beanRadioButton.putClientProperty(Refreshable.PROPERTY_FIXED_VALUE, TRANSACTION_TYPE_BEAN);
        containerRadioButton.putClientProperty(Refreshable.PROPERTY_FIXED_VALUE, TRANSACTION_TYPE_CONTAINER);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        sessionTypeButtonGroup = new javax.swing.ButtonGroup();
        transactionTypeButtonGroup = new javax.swing.ButtonGroup();
        sessionUnmatchedRadioButton = new javax.swing.JRadioButton();
        transactionUnmatchedRadioButton = new javax.swing.JRadioButton();
        nameLabel = new javax.swing.JLabel();
        ejbNameTextField = new javax.swing.JTextField();
        sessionTypeLabel = new javax.swing.JLabel();
        statelessRadioButton = new javax.swing.JRadioButton();
        statefulRadioButton = new javax.swing.JRadioButton();
        beanRadioButton = new javax.swing.JRadioButton();
        containerRadioButton = new javax.swing.JRadioButton();
        transactionTypeLabel = new javax.swing.JLabel();
        layoutHelperLabel = new javax.swing.JLabel();

        sessionTypeButtonGroup.add(sessionUnmatchedRadioButton);
        sessionUnmatchedRadioButton.setText("null");

        transactionTypeButtonGroup.add(transactionUnmatchedRadioButton);
        transactionUnmatchedRadioButton.setSelected(true);
        transactionUnmatchedRadioButton.setText("null");

        setLayout(new java.awt.GridBagLayout());

        nameLabel.setLabelFor(ejbNameTextField);
        nameLabel.setText(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "LBL_EjbName")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(nameLabel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(ejbNameTextField, gridBagConstraints);
        ejbNameTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "ACSD_EJB_Name")); // NOI18N

        sessionTypeLabel.setText(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "LBL_SessionType")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(sessionTypeLabel, gridBagConstraints);

        sessionTypeButtonGroup.add(statelessRadioButton);
        statelessRadioButton.setText(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "LBL_Stateless")); // NOI18N
        statelessRadioButton.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(statelessRadioButton, gridBagConstraints);
        statelessRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "ACSD_Stateless")); // NOI18N

        sessionTypeButtonGroup.add(statefulRadioButton);
        statefulRadioButton.setText(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "LBL_Stateful")); // NOI18N
        statefulRadioButton.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(statefulRadioButton, gridBagConstraints);
        statefulRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "ACSD_Stateful")); // NOI18N

        transactionTypeButtonGroup.add(beanRadioButton);
        beanRadioButton.setText(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "LBL_Bean")); // NOI18N
        beanRadioButton.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(beanRadioButton, gridBagConstraints);
        beanRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "ACSD_TX_Bean")); // NOI18N

        transactionTypeButtonGroup.add(containerRadioButton);
        containerRadioButton.setText(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "LBL_Container")); // NOI18N
        containerRadioButton.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(containerRadioButton, gridBagConstraints);
        containerRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "ACSD_TX_Container")); // NOI18N

        transactionTypeLabel.setText(org.openide.util.NbBundle.getMessage(SessionOverviewForm.class, "LBL_Transaction_Type")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(transactionTypeLabel, gridBagConstraints);

        layoutHelperLabel.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(layoutHelperLabel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton beanRadioButton;
    private javax.swing.JRadioButton containerRadioButton;
    private javax.swing.JTextField ejbNameTextField;
    private javax.swing.JLabel layoutHelperLabel;
    private javax.swing.JLabel nameLabel;
    private javax.swing.ButtonGroup sessionTypeButtonGroup;
    private javax.swing.JLabel sessionTypeLabel;
    private javax.swing.JRadioButton sessionUnmatchedRadioButton;
    private javax.swing.JRadioButton statefulRadioButton;
    private javax.swing.JRadioButton statelessRadioButton;
    private javax.swing.ButtonGroup transactionTypeButtonGroup;
    private javax.swing.JLabel transactionTypeLabel;
    private javax.swing.JRadioButton transactionUnmatchedRadioButton;
    // End of variables declaration//GEN-END:variables

    public JTextField getEjbNameTextField() {
        return ejbNameTextField;
    }

    public ButtonGroup getSessionTypeButtonGroup() {
        return sessionTypeButtonGroup;
    }

    public ButtonGroup getTransactionTypeButtonGroup() {
        return transactionTypeButtonGroup;
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void setValue(JComponent source, Object value) {

    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {

    }
}
