/* 
 * $Id: ctkscale.h,v 1.4 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKSCALE_H__
# define __CTKSCALE_H__ 

typedef struct CtkScale_S {
	CtkRange range;
	
	gboolean draw_value;
	
	CtkPositionType value_pos;
} CtkScale;

void ctk_scale_init(CtkScale *scale);
void ctk_scale_set_digits(CtkScale *scale, gint digits);
void ctk_scale_set_draw_value(CtkScale *scale, gboolean draw_value);
void ctk_scale_set_value_pos(CtkScale *scale, CtkPositionType pos);

#define CTK_SCALE(obj)	CTK_CHECK_CAST((obj),CtkScale,CtkTypeScale)

#endif
