/* 
 * $Id: ctkcolor.c,v 1.13 2000/07/12 02:03:07 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/* CTK Color */

#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "ctkcolor.h"
#include "ctk.h"

gchar* slang_colours[] =
{
	"black",
	"red",
	"green",
	"brown",
	"blue",
	"magenta",
	"cyan",
	"lightgray",
	"gray",
	"brightred",
	"brightgreen",
	"yellow",
	"brightblue",
	"brightmagenta",
	"brightcyan",
	"white"
};

/* Get the color ID's real name */
gchar* ctk_color_get_name(gint id)
{
	return slang_colours[id];
}

void ctk_color_init()
{
}

/* Get Parent Main Color */
CtkWidget* ctk_color_get_parent_widget(CtkWidget* widget)
{
      GNode*     parent_node = NULL;
      CtkObject* parent_object = NULL;

      if (!widget)
	    return NULL;
      
      for (parent_node = widget->node; parent_node; parent_node = parent_node->parent)
      {
	    parent_object = CTK_OBJECT(parent_node->data);

	    // These are colour transparent
/*		if (!CTK_CHECK_TYPE(parent_widget, CtkTypeTable) &&
		    (  !CTK_CHECK_TYPE(parent_widget,             CtkTypeTableChild) ||
		        CTK_CHECK_TYPE(parent_node->parent->data, CtkTypeCList)
		    ) &&
		    ((CtkObject *)parent_widget)->type != CtkTypeCheckButton &&
		    ((CtkObject *)parent_widget)->type != CtkTypeRadioButton &&
		    ((CtkObject *)parent_widget)->type != CtkTypeViewport &&
		    !CTK_CHECK_TYPE(parent_widget, CtkTypeItem) &&
		    ((CtkObject *)parent_widget)->type != CtkTypeScrolledWindow)
			break;
*/
		
	    // Only tablechild, window, notebook, and button set colours
	    if (parent_object->type == CtkTypeWindow   || 
	    	parent_object->type == CtkTypeNotebook ||
		parent_object->type == CtkTypeButton   ||
		parent_object->type == CtkTypeToggleButton ||
		( parent_object->type == CtkTypeTableChild &&
		  CTK_CHECK_TYPE(parent_node->parent->data, CtkTypeCList)))
		  break;
	        
	    parent_object = NULL;
      }

      return CTK_WIDGET(parent_object);
}
