/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation 
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>



/* 
 * gtrans_button_with_stock_n_label
 * @stock  : gnome stock pixmap id
 * @title  : label for the button
 * Create a button with a gnome stock and a label.
 */
GtkWidget *
gtrans_button_with_stock_n_label(gchar      *stock,
				 gchar      *title)
{
	GtkWidget     *button;
	GtkWidget     *pixmap;
	
	pixmap = gnome_stock_new_with_icon(stock);
	button = gnome_pixmap_button(pixmap,title);
	
	return button;
}




/* 
 * gtrans_button_with_stock_n_label2
 * @stock  : gnome stock pixmap id
 * @title  : label for the button
 * Create a button with a gnome stock and a label.
 */
GtkWidget *
gtrans_button_with_stock_n_label2(gchar      *stock,
				  gchar      *title)
{
	GtkWidget     *button;
	GtkWidget     *hbox;
	GtkWidget     *pixmap;
	GtkWidget     *label;
	
	button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(button),hbox);
	
	pixmap = gnome_stock_new_with_icon(stock);
	gtk_box_pack_start(GTK_BOX(hbox),pixmap,FALSE,FALSE,0);
	
	label = gtk_label_new(title);
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	
	gtk_widget_show_all(hbox);
		
	return button;
}



/* 
 * gtrans_button_with_xpm_data_n_label
 * @xpm_data : xpm data
 * @title    : label for the button
 * Create a button with a gnome stock and a label.
 */
GtkWidget *
gtrans_button_with_xpm_data_n_label(gchar     **xpm_data,
				    gchar      *title)
{
	GtkWidget      *button;
	GtkWidget      *pixdget;
	
	pixdget = gnome_pixmap_new_from_xpm_d(xpm_data);	
	button = gnome_pixmap_button(pixdget,title);
	
	return button;
}



/* 
 * gtrans_button_with_xpm_data_n_label2
 * @xpm_data : xpm data
 * @title    : label for the button
 * Create a button with a gnome stock and a label.
 */
GtkWidget *
gtrans_button_with_xpm_data_n_label2(gchar     **xpm_data,
				     gchar      *title)
{
	GtkWidget     *button;
	GtkWidget     *hbox;
	GtkWidget     *pixmap;
	GtkWidget     *label;
	
	button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(button),hbox);
	
	pixmap = gnome_pixmap_new_from_xpm_d(xpm_data);	
	gtk_box_pack_start(GTK_BOX(hbox),pixmap,FALSE,FALSE,0);
	
	label = gtk_label_new(title);
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	
	gtk_widget_show_all(hbox);
	
	return button;
}

