/*  cssed (c) Iago Rubio, 2003-2004 - A tiny CSS editor.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
void
cssed_error_message (gchar * message, gchar * title);

gchar*
gdk_color_to_rgb_triplet_string( GdkColor* color);

gint
gdk_color_to_scintilla_integer_color( GdkColor* color );

GtkWidget*
create_custom_button_from_stock(gchar* label_text,gchar *stock_id);

gchar*
allocated_buffer_add_string(gchar* buffer, const gchar* string);

GtkWidget*
create_ok_cancel_dialog (gchar* title, gchar* message);

GtkWidget*
create_yes_no_cancel_dialog (gchar* title, gchar* message);

GtkWidget*
create_unsaved_files_dialog (void);
/* this must be changed to a window function FIXME */
void
init_default_config( CssedWindow *window );
/* this must be changed to a window function FIXME */
void
save_config_to_file(CssedWindow* window);

void 
cssed_config_copy_style_and_defaults( CssedConfig* source, CssedConfig* target );

gboolean
char_ptr_is_decimal_num(const gchar* ptr);
/* this must be changed to a window function FIXME */
void
load_all_plugins( CssedWindow* cssedwin, GList* plugins_to_load );

// compare two tree view inters containig a markupo string
// clean up the markup and compare the strings
gint
tree_iter_doc_scanner_compare_string(	GtkTreeModel *model,
                                  		GtkTreeIter *a,
                                  		GtkTreeIter *b,
                                  		gpointer user_data);
										
// to load and save a GtkTextBuffer into a file without error checking
void
text_buffer_load_contents( GtkTextBuffer* buffer, gchar* filename );
void
text_buffer_save_contents( GtkTextBuffer* buffer, gchar* filename );

// to load to and from the scratch pad
void
scratch_pad_load_contents( GtkTextBuffer* scratch_pad_buffer );
void
scratch_pad_save_contents( GtkTextBuffer* scratch_pad_buffer );
CssedEolMode
buffer_get_first_eol( gchar* buffer_start, gchar* buffer_end );

