#define _POSIX_C_SOURCE 199309L /*whatever that may mean...*/
#define _BSD_SOURCE             /*I use strdup, S_IFDIR, etc */
/* #define __USE_BSD */

/* Due to a (possibly?) buggy sys/stat.h or sys/time.h on SunOs 5.6,
   I seem to have to define this. Anyone know why? (or a better solution?) */
#define __EXTENSIONS__ 234


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <dirent.h>
#include <syslog.h>
#include <search.h>
#include <ctype.h>

#include <regex.h>

/*#include "libvpath.h"*/
#include "libtricks.h"
#include "vsearch.h"
#include "wrapped.h"

#include "errno_str.h"


/* #define TESTING */
#ifdef TESTING
#define next___lxstat __lxstat
#define next_opendir  opendir
#define next_closedir closedir
#define next_readdir  readdir
#define next_telldir  telldir
#define wrapped_lxstat(a,b,c) __lxstat(b,c)
#endif


/* the get_cwd function I copied from glibc-2 used a __set_errno function.
   The following is to try to read if from the headers. If that fails,
   use a #define
*/
#ifdef __GNULIBC
#  define _LIBC
#  include <errnos.h>
#  undef _LIBC
#endif

#ifndef _D_EXACT_NAMLEN
/* this didn't work on SunOs 5.6, so I'll put in another strlen...*/
/*#  define _D_EXACT_NAMLEN(a) (d->d_namlen)*/
#  define _D_EXACT_NAMLEN(a) (strlen(d->d_name))
#endif

#ifndef _D_ALLOC_NAMLEN
/*#  define _D_ALLOC_NAMLEN(a)  (d->d_namlen+1) */
#  define _D_ALLOC_NAMLEN(a)  (strlen(d->d_name)+1)
#endif

#ifndef __set_errno
#  define __set_errno(a)   errno=a
#endif

/* ERANGE: Also used by the glibc-2 function, also defined in errnos.h */
#ifndef ERANGE
#  define ERANGE 34
#endif

#include <limits.h> 

#ifndef __GNUC__
#  define __attribute__(a)
#endif

struct vpath_checkfunc; 
struct path_st;
struct process_paths;

#define DOIT_ARGS (const struct vpath_checkfunc *,  \
		   const struct path_st *,          \
		   struct process_paths *,          \
                   int *)


typedef int(*func_type)DOIT_ARGS;

typedef enum
{ first_func=-1,
  chop_func,
  check_func,
  nice_func,
  isexist_func,
  isread_func,  iswrite_func,  isexec_func,  isdir_func,  
  needread_func,needwrite_func,needexec_func,needdir_func, needexcl_func,
  needstat_func,needchfl_func,needunl_func,
  settime_func, agetime_func,
  stdout_func,stderr_func,writefile_func,syslog_func,system_func,
  return_func,
  last_func
}func_enum;

typedef enum
{ func_return_unchanged,
  func_return_not,
  func_return_ignore
}func_return_enum;


static int do_chop      DOIT_ARGS;
static int do_check     DOIT_ARGS;
static int do_nice      DOIT_ARGS;
static int do_isexist   DOIT_ARGS;
static int do_isread    DOIT_ARGS;
static int do_iswrite   DOIT_ARGS;
static int do_isexec    DOIT_ARGS;
static int do_isdir     DOIT_ARGS;
static int do_needread  DOIT_ARGS;
static int do_needwrite DOIT_ARGS;
static int do_needexec  DOIT_ARGS;
static int do_needdir   DOIT_ARGS;
static int do_needexcl  DOIT_ARGS;
static int do_needstat  DOIT_ARGS;
static int do_needchfl  DOIT_ARGS;
static int do_needunli  DOIT_ARGS;

static int do_settime   DOIT_ARGS;
static int do_agetime   DOIT_ARGS;

static int do_stdout    DOIT_ARGS;
static int do_stderr    DOIT_ARGS;
static int do_writefile DOIT_ARGS;
static int do_syslog    DOIT_ARGS;
static int do_system    DOIT_ARGS;
static int do_return    DOIT_ARGS;


static char *func_str[]={
  "chop",
  "check",
  "nice",
  "isexist",
  "isread",  "iswrite",  "isexec",  "isdir",
  "needread","needwrite","needexec","needdir","needexcl",
  "needstat","needchfl","needunl",
  "settime", "agetime",
  "stdout","stderr","writefile","syslog","system",
  "return",
  NULL
};


static func_type func_arr[]={
  do_chop,
  do_check,
  do_nice,
  do_isexist,
  do_isread,  do_iswrite,  do_isexec,  do_isdir,
  do_needread,do_needwrite,do_needexec,do_needdir,do_needexcl,
  do_needstat,do_needchfl,do_needunli,
  do_settime, do_agetime,
  do_stdout, do_stderr, do_writefile, do_syslog, do_system,
  do_return,
  NULL
};

struct process_paths{
  /* argument passed to the do_* functions */

  const char *inname; /* name as given by the wrapped function */
  const char *nicename;/* inname with `../dir' removed (etc) 
			 made by do_nice(), findpath/opendir
			 set this to to inname, so it has a good default */
  char *choppedname;  /* name with ``root'' chopped off 
			 space provided by findpath/opendir
			 made by do_chop() */
  char *outname;      /* name with directory in vpath prepended 
			 space provided by findpath/opendir,
			 made by do_isexist() */
  struct stat *st;    /* results of most resent stat 
			 made by do_isexist() */
  mode_t need_mode;   /* permissions needed for the wrapped function 
			 bits are same as in stat(2), execpt that
			 group/other r/w/x bits are not used */
};

struct vpath_checkfunc{
  int  (*doit)DOIT_ARGS;
  const void *param;
  int  ret_mod;
};

/* path_st is used to store one path element (like 'chop("hoi")=',
   or 'needread&isexist&iswrite&stderr("hello")=/bin"' */
   
struct path_st{
  char *s;                   /* the string after the equal sign (=) */
  struct vpath_checkfunc *f; /* array of functions before the equal sign*/
};

struct vpath_st{
  struct path_st *path;
};
struct vpath_st *vpath=0;

#define SLASHTERM 1
#define NOSLASHTERM 0


struct vpath_DIR{
  void *dirdata;
  int offset; /*offset in dirdata, or -1 if dir is outside vpath,
		(and *dirdata contains the normal DIR *).*/
};

struct vpath_treekey{
  void **treeroot; 
  char *s;
  long ino;
  void **vd;
};


static const char *extseperator=NULL;   /* usually "=" */

static int min(int x, int y){return x<y? x:y;}
/* static int max(int x, int y){return x>y? x:y;} */

static char *vpath_strncpy(char *dest, const char *src, unsigned int max){
  /* does what strncpy should have done: */
  
  if(strlen(src) < max)
    return strcpy(dest,src);
  else {
    if(max>1)
      memcpy(dest,src,max-1);
    if(max>0)
      dest[max-1]=0;
    else 
      return NULL;
    return dest;
  }
}
/*
static const char *vpath_strnchr(const char *s, int n, int c){
  int i;
  for(i=0; (i<n) && *s; s++,i++)
    if(*s==c)
      return s;
  return NULL;
}
*/
static char *vpath_strnstr(const char *s, int n, const char *needle){
  int i;
  int l=strlen(needle);
  int bracket_level;
  int inquote;
  int escaped;

  bracket_level=0;
  inquote=0;
  escaped=0;

  for(i=0; (i<(n-l+1)) && *s; s++,i++){
    switch (*s){
    case '(':
      if(!inquote && !escaped)
	bracket_level++;
      break;
    case ')':
      if(!inquote && !escaped)
	bracket_level--;
      break;
    case '"':
      if(!escaped)
	inquote=!inquote;
      break;
    default:;
    }
    if(!inquote && (bracket_level==0))
      if(!strncmp(s,needle,l))
	return (char *)s;
    escaped=*s=='\\';
  }
  return NULL;
}

static char *vpath_strncat(char *dest, const char *src, unsigned int max){
  /* does what strncat should have done: */
  /* if src+dest is less than max long, do the strcat.
     Otherwise, return NULL*/
  
  if(strlen(src)+strlen(dest) < max)
    return strcat(dest,src);
  else 
    return NULL;
}

static const char *skip_whitespace(const char *s, const char *end){
  while((s<end)&&isspace(*s))
    s++;
  return s;
}

#ifdef PROC_CMDLINE
static const char *commandline(){
  static char buf[PATH_MAX];
  static const char *initialized=0;

  int fd;
  int nread;
  static const char errmsg[]="ERROR-couldn't open /proc/PID/cmdline";
  char *s;

  if(initialized)
    return initialized;

  sprintf(buf,"/proc/%i/cmdline",getpid());
  fd=next_open(buf,O_RDONLY,0);
  if(fd<0)
    return initialized=errmsg;

  nread=read(fd,buf,sizeof(buf)-1);
  if(nread==-1){
    close(fd);
    return initialized=errmsg;
  }
  for(s=buf;(s-buf)<nread; s++)
    if(!*s)
      *s=' ';
  buf[nread]=0;
  close(fd);
  return initialized=buf;
}
#endif /* PROC_CMDLINE */



/* The libc getcwd calls lxstat() etc, wich unfortunately
   is wrapped. As I didn't know how to prevent this, I simply
   copyied the whole getcwd function from GNU libc, and replaced
   the lxstat() etc calls by next__lxstat calls.
*/
char *vpath_getcwd (char *buf, size_t size)
{
  
  static const char dots[]
    = "../../../../../../../../../../../../../../../../../../../../../../../\
../../../../../../../../../../../../../../../../../../../../../../../../../../\
../../../../../../../../../../../../../../../../../../../../../../../../../..";
  const char *dotp, *dotlist;
  size_t dotsize;
  dev_t rootdev, thisdev;
  ino_t rootino, thisino;
  char *path;
  register char *pathp;
  struct stat st;

  if (size == 0)
    {
      if (buf != NULL)
	{
	  __set_errno (EINVAL);
	  return NULL;
	}

      size = PATH_MAX + 1;
    }

  if (buf != NULL)
    path = buf;
  else
    {
      path = malloc (size);
      if (path == NULL)
	return NULL;
    }

  pathp = path + size;
  *--pathp = '\0';

  if (next___lxstat (ARG_IFSTATVER(_STAT_VER) ".", &st) < 0)
    return NULL;
  thisdev = st.st_dev;
  thisino = st.st_ino;

  if (next___lxstat (ARG_IFSTATVER(_STAT_VER) "/", &st) < 0)
    return NULL;
  rootdev = st.st_dev;
  rootino = st.st_ino;

  dotsize = sizeof (dots) - 1;
  dotp = &dots[sizeof (dots)];
  dotlist = dots;
  while (!(thisdev == rootdev && thisino == rootino))
    {
      register DIR *dirstream;
      struct dirent *d;
      dev_t dotdev;
      ino_t dotino;
      char mount_point;

      /* Look at the parent directory.  */
      if (dotp == dotlist)
	{
	  /* My, what a deep directory tree you have, Grandma.  */
	  char *new;
	  if (dotlist == dots)
	    {
	      new = malloc (dotsize * 2 + 1);
	      if (new == NULL)
		return NULL;
	      memcpy (new, dots, dotsize);
	    }
	  else
	    {
	      new = realloc ((void *) dotlist, dotsize * 2 + 1);
	      if (new == NULL)
		goto lose;
	    }
	  memcpy (&new[dotsize], new, dotsize);
	  dotp = &new[dotsize];
	  dotsize *= 2;
	  new[dotsize] = '\0';
	  dotlist = new;
	}

      dotp -= 3;

      /* Figure out if this directory is a mount point.  */
      if (wrapped_lxstat (DONTVPATH, ARG_IFSTATVER(_STAT_VER) dotp, &st, NULL) < 0)
	goto lose;
      dotdev = st.st_dev;
      dotino = st.st_ino;
      mount_point = dotdev != thisdev;

      /* Search for the last directory.  */
      dirstream = next_opendir (dotp);
      if (dirstream == NULL)
	goto lose;
      while ((d = next_readdir (dirstream)) != NULL)
	{
	  if (d->d_name[0] == '.' &&
	      (d->d_name[1] == '\0' ||
	       (d->d_name[1] == '.' && d->d_name[2] == '\0')))
	    continue;
	  if (mount_point || (ino_t) d->d_ino == thisino)
	    { 
	      char *name;
	      int r;
	      name=(char*)malloc(dotlist + dotsize - dotp + 1 + _D_ALLOC_NAMLEN (d));
	      memcpy (name, dotp, dotlist + dotsize - dotp);
	      name[dotlist + dotsize - dotp] = '/';
	      strcpy (&name[dotlist + dotsize - dotp + 1], d->d_name);
	      r=wrapped_lxstat (DONTVPATH, ARG_IFSTATVER(_STAT_VER) name, &st, NULL);
	      free(name);
	      if (r < 0)
		{
		  int save = errno;
		  (void) next_closedir (dirstream);
		  __set_errno (save);
		  goto lose;
		}
	      if (st.st_dev == thisdev && st.st_ino == thisino)
		break;
	    }
	}
      if (d == NULL)
	{
	  int save = errno;
	  (void) next_closedir (dirstream);
	  __set_errno (save);
	  goto lose;
	}
      else
	{
	  size_t namlen = _D_EXACT_NAMLEN (d);

	  if ((size_t) (pathp - path) <= namlen)
	    {
	      if (buf != NULL)
		{
		  (void) next_closedir (dirstream);
		  __set_errno (ERANGE);
		  goto lose;
		}
	      else
		{
		  size *= 2;
		  buf = realloc (path, size);
		  if (buf == NULL)
		    {
		      (void) next_closedir (dirstream);
		      free (path);
		      __set_errno (ENOMEM);/* closedir might have changed it.*/
		      goto lose;
		    }
		  pathp = &buf[pathp - path + size / 2];
		  path = buf;
		  /* Move current contents up to the end of the buffer.
		     This is guaranteed to be non-overlapping.  */
		  memcpy (pathp, pathp - size / 2, path + size - pathp);
		}
	    }
	  pathp -= namlen;
	  (void) memcpy (pathp, d->d_name, namlen);
	  *--pathp = '/';
	  (void) next_closedir (dirstream);
	}

      thisdev = dotdev;
      thisino = dotino;
    }

  if (pathp == &path[size - 1])
    *--pathp = '/';

  if (dotlist != dots)
    free ((void *) dotlist);

  memmove (path, pathp, path + size - pathp);
  return path;

 lose:
  if (dotlist != dots)
    free ((void *) dotlist);
  return NULL;
}



static void nicepath(const char *path, 
		      char *dest,
		      int type UNUSED){
  /* use "getcwd" to make the path ``nice'', i.e.:
     if the cwd is "/home/me", this function returns:
        path="hello"          -> return "/home/me/hello"
	path="../her/file"    -> return "/home/her/file"
	path="/../bin/../dev" -> return "/dev"
     
     the returned string is malloced, the caller has to free
     the returned string him/herself.
     
     path - the path to be niced.
     n    - length of 'path' to be used.
     type - 0  file, don't terminate with a slash (not used??)
     type - 1  directory, terminate with a slash
     
  */

  const char *s;
  int n=strlen(path);
  char old_cwd[PATH_MAX];
  
  if(! vpath_getcwd(old_cwd,sizeof(old_cwd)-2) )return ;/*??*/
  
  if(*path){
    s=path+n;
    dest[0]=0;
    while((s>path) && (*(s-1)!='/'))
      s--;
    if(s-path){
      if(! vpath_strncpy(dest,path,s-path+1)  ) goto restore_cwd;
      if(  chdir(dest)                        ) goto restore_cwd;
    }
    if(! vpath_getcwd(dest,PATH_MAX-2)   )  goto restore_cwd; /*??*/
    if(!strlen(dest) || (dest[strlen(dest)-1]!='/'))
      if(! vpath_strncat(dest,"/",PATH_MAX)  )goto restore_cwd;
    if(strlen(dest)+n-(s-path) >= PATH_MAX-2) goto restore_cwd;
    strncat(dest,s,n-(s-path));
    /*  if(type && dest[strlen(dest)-1]!='/')
	if(! vpath_strncat(dest,"/",PATH_MAX))  ) goto restore_cwd;*/
  }else
    strcpy(dest,old_cwd);
  
 restore_cwd:
  chdir(old_cwd);
  return;
}


/*************************************************************/
/*************************************************************/
/*                                                           */
/*             All of them do_it functions                   */
/*                                                           */
/*************************************************************/
/*************************************************************/

int do_chop(const struct vpath_checkfunc *f,
	    const struct path_st *path UNUSED,
	    struct process_paths *pr,
	    int *vpath_errno UNUSED){

  regmatch_t m;
  regex_t *c=(regex_t *)f->param;

  if(regexec(c,pr->nicename,1,&m,0)){
    /* also copy to choppedname, in case the return value of
       chop() is ignored
    */
    strcpy(pr->choppedname,pr->nicename);
    return 0;
  }
  strcpy(pr->choppedname,pr->nicename+m.rm_eo);
  return 1;  
}
int do_check(const struct vpath_checkfunc *f,
	    const struct path_st *path UNUSED,
	    struct process_paths *pr,
	    int *vpath_errno UNUSED){

  regmatch_t m;
  regex_t *c=(regex_t *)f->param;

  if(regexec(c,pr->nicename,1,&m,0))
    return 0;

  return 1;  
}
int do_nice(const struct vpath_checkfunc *f UNUSED,
	    const struct path_st *path UNUSED,
	    struct process_paths *pr,
	    int *vpath_errno UNUSED){

  
  nicepath(pr->inname,(char *)pr->nicename,0);
  return 1;  
}
int do_isexist(const struct vpath_checkfunc *f UNUSED,
	       const struct path_st *path,
	       struct process_paths *pr,
	    int *vpath_errno UNUSED){
  int r;
  
  strcpy(pr->outname,path->s);
  strcat(pr->outname,pr->choppedname);
  r=wrapped_lxstat(DONTVPATH, ARG_IFSTATVER(_STAT_VER) pr->outname,
		   pr->st, NULL);
  return !r;
}

int do_isread(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr,
	      int *vpath_errno UNUSED){

  
  return 
    ((getuid()==pr->st->st_uid)&&(S_IRUSR&pr->st->st_mode))||
    ((getgid()==pr->st->st_gid)&&(S_IRGRP&pr->st->st_mode))||
    ((S_IROTH&pr->st->st_mode));
    ;
}
int do_iswrite(const struct vpath_checkfunc *f UNUSED,
	       const struct path_st *path UNUSED,
	       struct process_paths *pr,
	       int *vpath_errno UNUSED){

  
  return 
    ((getuid()==pr->st->st_uid)&&(S_IWUSR&pr->st->st_mode))||
    ((getgid()==pr->st->st_gid)&&(S_IWGRP&pr->st->st_mode))||
    ((S_IWOTH&pr->st->st_mode));
    ;
}

int do_isexec(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr,
	      int *vpath_errno UNUSED){
  
  
  return 
    ((getuid()==pr->st->st_uid)&&(S_IXUSR&pr->st->st_mode))||
    ((getgid()==pr->st->st_gid)&&(S_IXGRP&pr->st->st_mode))||
    ((S_IXOTH&pr->st->st_mode));
    ;
}
int do_isdir(const struct vpath_checkfunc *f UNUSED,
	     const struct path_st *path UNUSED,
	     struct process_paths *pr,
	     int *vpath_errno UNUSED){
  
  return S_ISDIR(pr->st->st_mode);
}
int do_needread(const struct vpath_checkfunc *f UNUSED,
		const struct path_st *path UNUSED,
		struct process_paths *pr,
		int *vpath_errno UNUSED){

  return pr->need_mode & NEED_READ;
}
int do_needwrite(const struct vpath_checkfunc *f UNUSED,
		 const struct path_st *path UNUSED,
		 struct process_paths *pr,
		 int *vpath_errno UNUSED){
  
  return pr->need_mode & NEED_WRITE;
}

int do_needexec(const struct vpath_checkfunc *f UNUSED,
		const struct path_st *path UNUSED,
		struct process_paths *pr,
		int *vpath_errno UNUSED){

  return pr->need_mode & NEED_EXEC;
}
int do_needdir(const struct vpath_checkfunc *f UNUSED,
	       const struct path_st *path UNUSED,
	       struct process_paths *pr,
	       int *vpath_errno UNUSED){

  return pr->need_mode & NEED_DIR;
}
int do_needexcl(const struct vpath_checkfunc *f UNUSED,
		const struct path_st *path UNUSED,
		struct process_paths *pr,
		int *vpath_errno UNUSED){
  
  return pr->need_mode & NEED_EXCL;
}
int do_needstat(const struct vpath_checkfunc *f UNUSED,
		const struct path_st *path UNUSED,
		struct process_paths *pr,
		int *vpath_errno UNUSED){
  
  return pr->need_mode & NEED_STAT;
}
int do_needchfl(const struct vpath_checkfunc *f UNUSED,
		const struct path_st *path UNUSED,
		struct process_paths *pr,
		int *vpath_errno UNUSED){
  
  return pr->need_mode & NEED_CHFL;
}
int do_needunli(const struct vpath_checkfunc *f UNUSED,
		const struct path_st *path UNUSED,
		struct process_paths *pr,
		int *vpath_errno UNUSED){
  
  return pr->need_mode & NEED_UNLI;
}
int do_settime(const struct vpath_checkfunc *f UNUSED,
	       const struct path_st *path UNUSED,
	       struct process_paths *pr,
	       int *vpath_errno UNUSED){

  long int *i=(long int *)f->param;
  
  pr->st->st_atime =*i;
  pr->st->st_mtime =*i;
  pr->st->st_ctime =*i;
  return 1;
}
int do_agetime(const struct vpath_checkfunc *f UNUSED,
	       const struct path_st *path UNUSED,
	       struct process_paths *pr,
	       int *vpath_errno UNUSED){

  int *i=(int *)f->param;

  
  pr->st->st_atime -= *i;
  pr->st->st_mtime -= *i;
  pr->st->st_ctime -= *i;
  return 1;
}

char *replace_out(char *buf,
		  const char *s, 
		  const struct process_paths *pr){
  char *t;

  *buf=0;

  for(t=buf; *s && (t-buf)<(PATH_MAX-20);){
    /* don't fill buf with more than PATH_MAX elements.
       We need sprintf(), but only in cases where we can be sure it
       will not print more than 5 chars, so in the loop use
       PATH_MAX-20 to be safe */
    if(!strncmp(s,"$name",strlen("$name"))){
      vpath_strncpy(t, pr->nicename,PATH_MAX-(t-buf)-10);
      s+=strlen("$name");
    }
    else if(!strncmp(s,"$is",strlen("$is"))){
      sprintf(t,"%o",pr->st->st_mode);
      s+=strlen("$is");
    }
    else if(!strncmp(s,"$need", strlen("$need"))){
      sprintf(t,"%o",pr->need_mode);
      s+=strlen("$need");
    } 
    else if(!strncmp(s,"$PID", strlen("$PID"))){
      sprintf(t,"%i",getpid());
      s+=strlen("$PID");
    } 
#ifdef PROC_CMDLINE
    else if(!strncmp(s,"$cmd", strlen("$ccmd"))){
      vpath_strncpy(t,commandline(),PATH_MAX-(t-buf)-10);
      s+=strlen("$cmd");
    } 
#endif /* PROC_CMDLINE */
    else{
      *t=*s;
      *(t+1)=0;
      s+=1;
    }
    t+=strlen(t);
  }
  return buf;
}

int do_stdout(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr,
	      int *vpath_errno UNUSED){

  char *s=(char *)f->param;
  char buf[PATH_MAX*2];

  printf("%s\n",replace_out(buf,s,pr));
  return 1;
}

int do_stderr(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr,
	      int *vpath_errno UNUSED){

  char *s=(char *)f->param;
  char buf[PATH_MAX];

  fprintf(stderr,"%s\n",replace_out(buf,s,pr));
  return 1;
}

int do_writefile(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr,
	      int *vpath_errno UNUSED){

  char *filename=((char **)f->param)[0];
  char *s=((char **)f->param)[1];
  char buf[PATH_MAX];
  FILE *file;

  file=next_fopen(filename,"a");
  if(!file){
    fprintf(stderr,
	    "libtricks: ERROR, cannot open file %s in writefile function (%s)",
	    filename,
	    strerror(errno));
    return 0;
	    
  }
  fprintf(file,"%s\n",
	  replace_out(buf,s,pr));
  fclose(file);
  return 1;
}

int do_syslog(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr,
	      int *vpath_errno UNUSED){

  char *s=(char *)f->param;
  char buf[PATH_MAX];
  openlog("libtricks", LOG_PID, LOG_USER);
  syslog(LOG_DEBUG,replace_out(buf,s,pr));
  return 1;
}

int do_system(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr,
	      int *vpath_errno UNUSED){

  char *s=(char *)f->param;
  char buf[PATH_MAX];
  system(replace_out(buf,s,pr));
  return 1;
}

int do_return(const struct vpath_checkfunc *f UNUSED,
	      const struct path_st *path UNUSED,
	      struct process_paths *pr UNUSED,
	      int *vpath_errno){

  int *i=(int*)f->param;

  *vpath_errno=*i;
  return !i;
}


/*************************************************************/
/*************************************************************/
/*                                                           */
/*             parsing stuff                                 */
/*                                                           */
/*************************************************************/
/*************************************************************/




func_enum vpath_readfunc(const char *s, int n){
  func_enum i;
  for(i=first_func+1; func_str[i]; i++)
    if(!strncmp(s,func_str[i],min(n,strlen(func_str[i]))))
      return i;
  return first_func;
}

static char **read_param_stringn(const char **s,
				 int n,
				 int nstr){
  const char *t;
  const char *end=*s+n;
  char **params;
  int istr=0;
  char buf[PATH_MAX];
  int i;
  int escaped;

  params=(char **)malloc(sizeof(char *)*nstr);

  t=skip_whitespace(*s,end);

  if(*t!='(' || (end-t <= 0))
    goto error;
  t++;
  
  do {
    t=skip_whitespace(t,end);
    if(*t!='\"' || (end-t <= 0))
      goto error;

    t++;
    escaped=0;
    for(i=0; (*t!='\"'||escaped) && (end-t >0); i+=!escaped, t++){
      escaped=(*t=='\\');
      buf[i]=*t;
    }
    buf[i]=0;
    params[istr]=strdup(buf);
    istr++;

    if(*t!='\"' || (end-t <=0))
      goto error;
    t++;

    if(istr < nstr){
      t=skip_whitespace(t,end);
      if(*t!=',' || (end-t <=0))
	goto error;
      t++;
    }
  } while (end-t >0 && istr<nstr );

  t=skip_whitespace(t,end);
  if(*t!=')' || (end-t <=0))
    goto error;
  
  *s=t+1;
  return params;

error:
  fprintf(stderr,
	  "libtrics: Error: string parameter(s) expected.\n"
	  "       syntax: func(\"string\"[,\"string\"]), with %i params\n"
	  "       In vpath \"%s\", read upto \"%s\"\n",nstr, *s,t);
  free(params); /* just for completeness */

  /* should also free pointers in params[], but don't feel like
     doing that. User should fix the VPATH anyway */

  return 0;
  
}

static char *read_param_string(const char **s,
			       int n){
  char **params;
  char *t;
  params=read_param_stringn(s,n,1);
  t=*params;
  free(params);
  return t;
}

static long int *read_param_int(const char **s,
			       int n){
  const char *t;
  long int *i;
  const char *end=*s+n;

  t=skip_whitespace(*s,end);
  if(n<3 || *t!='('){
    fprintf(stderr,"Error: int expected. Int par syntax: func([0-9][0-9]*)\n");
    return 0;
  }
  t=skip_whitespace(*s+1,end);
  i=malloc(sizeof(long int));
  *i=strtol(t,(char **)&t,10);
  
  t=skip_whitespace(t,end);
  if((t-*s>=n)||(*t!=')')){
    fprintf(stderr,"Error: int parameter not properly terminated\n");
    return 0;
  }
  *s=t+1;
  return i;
}


static long int *read_param_errno(const char **s,
				  int n){
  const char *t;
  long int *i;
  int i_err;
  int err=0; /* to stop egcs from warning about uninitialised var */

  const char *end=*s+n;

  t=skip_whitespace(*s,end);

  if(n<3 || *t!='(')
    goto error;
  
  t=skip_whitespace(t+1,end);

  if((t<end)&&isdigit(*t))
    return read_param_int(s,n);

  t=strchr(*s,')');
  if(!t || (t >= end))
    goto error;
  for(i_err=0; errno_str[i_err].str; i_err++)
    if(!strncmp(*s+1,errno_str[i_err].str,t-*s-1)){
      err=errno_str[i_err].no;
      break;
    }
  if(!errno_str[i_err].str)
    goto error;
  
  i=malloc(sizeof(long int));
  *i=err;
  
  *s=t+1;
  return i;

error:
  fprintf(stderr,
	  "libtrics: Error: errno expected.\n"
	  "       errno syntax: func(int|error #def)\n"
	  "       In string \"%s\", read upto \"%s\"\n",*s,t);
  
  return 0;
}
static void alloc_function(struct path_st *path,
			   int *size,
			   func_enum f, /*int (*doit)DOIT_ARGS,*/
			   const char *param,
			   int ret_mod){
  char *s;

  path->f=(struct vpath_checkfunc *)
    realloc(path->f,sizeof(struct vpath_checkfunc)*(*size+1));
  path->f[*size].doit=func_arr[f];
  path->f[*size].ret_mod=ret_mod;
  switch(f){
  case return_func:
  case settime_func:
  case agetime_func:
    path->f[*size].param=(void *)param;
    break;
  case chop_func:
  case check_func:
    {
      regex_t *c=(regex_t*)malloc(sizeof(regex_t));

      path->f[*size].param=(void*)c;
      s=malloc(strlen(param)+2);
      strcpy(s,"^");
      strcat(s,param);
      regcomp(c,s,REG_EXTENDED);
      free(s);
    }
    break;
  default:
    path->f[*size].param=param /*? (void *)strdup(param) : NULL*/;
  }
  
  (*size)++;
}
static void vpath_store_path(struct path_st *path,
			     const char *s,
			     int size,
			     int first_path){
  char buf[PATH_MAX];
  const char *sep_loc;
  const char *u, *old_u;
  func_enum f;
  int done_exists=0, done_chop=0, done_nice=0;
  int ret_mod;
  int i=0;
  

  path->f=NULL;
  
  sep_loc=vpath_strnstr(s,size,extseperator);
  if(!sep_loc){
    sep_loc=s-1;
    goto add_missing; 
  }
  u=s;
  i=0;
  while(u<sep_loc){
    old_u=skip_whitespace(u,sep_loc);
    while(*u=='&')
      u++;
    switch(*u){
    case '!':
      ret_mod=func_return_not;
      u++;
      break;
    case '-':
      ret_mod=func_return_ignore;
      u++;
      break;
    case first_func:
    case last_func:
    default:
      ret_mod=func_return_unchanged;
    }

    u=skip_whitespace(u,sep_loc);
    f=vpath_readfunc(u,sep_loc-u);
    if(f!=first_func)
      u+=strlen(func_str[f]);
    switch(f){
    case stdout_func:
    case stderr_func:
    case syslog_func:
    case system_func:
      alloc_function(path, &i, f,
		     read_param_string(&u,sep_loc-u),
		     ret_mod);
      break;
    case writefile_func:
      alloc_function(path, &i, f,
		     (const char*)read_param_stringn(&u,sep_loc-u,2),
		     ret_mod);
      break;
    case chop_func:
      done_chop=1;
    case check_func:
      if(!done_nice){
	done_nice=1;
	alloc_function(path, &i, nice_func, 
		       /* param=*/0, func_return_unchanged);
      }
      alloc_function(path, &i, chop_func,
		     read_param_string(&u,sep_loc-u),
		     ret_mod);
      break;
    case isexist_func:
      done_exists=1;
      alloc_function(path,&i, f,/* param=*/ 0, ret_mod);
      break;
    case return_func:
      alloc_function(path, &i, f,
		     (const char *)read_param_errno(&u,sep_loc-u),
		     ret_mod);

      break;
    case nice_func:
      done_nice=1;
    case needread_func:
    case needwrite_func:
    case needexec_func:
    case needdir_func:
    case needexcl_func:
    case needstat_func:
    case needchfl_func:
    case needunl_func:
      alloc_function(path, &i, f,/*param =*/ 0, ret_mod);
      break;
    case settime_func:
    case agetime_func:
      if(!done_chop){
	if(!done_nice){
	  done_nice=1;
	  alloc_function(path, &i, nice_func, /* param=*/0, 0);
	}
	done_chop=1;
	alloc_function(path,&i, chop_func,
		       /* param=*/strdup(getcwd(buf,sizeof(buf))),
		       func_return_unchanged);
      }
      if(!done_exists){
	done_exists=1;
	alloc_function(path, &i, isexist_func,/*param=*/ 0, func_return_unchanged);
      }
      alloc_function(path, &i, f, (const char *)read_param_int(&u, sep_loc-u), 0);
      break;
    case isread_func:
    case iswrite_func:
    case isexec_func:
    case isdir_func:
      if(!done_exists){
	done_exists=1;
	alloc_function(path, &i, isexist_func,/*param=*/ 0, func_return_unchanged);
      }
      alloc_function(path, &i, f, 0, ret_mod);
      break;
    default:
      printf("VPATH: Unknown function %s\n",u);
      exit(1);
    }
  }

 add_missing:
  path->s=malloc(size-(sep_loc-s));
  vpath_strncpy(path->s, sep_loc+1, size-(sep_loc-s));
  
  if((!done_exists) & (!first_path))
    alloc_function(path, &i, isexist_func,/*param=*/ 0, func_return_unchanged);


  alloc_function(path,&i, last_func,/* param=*/ 0, func_return_unchanged);

}

static struct vpath_st *get_vpath(){
  /* Read the VPATH environment variable, and store it in 
     the globel variable `vpath'. Also return pointer to that
     variable
  */
  if(!vpath){
    char *s,*t, *ext_end;
    char *delim;
    char *extdelim;
    int n;              /* number of vpath components */
    int  nvpath;        /* number of vpath's (in extended vpath) */
    int ivpath;
    int first_path;
    int i;

    delim=getenv(VPATHLIBDELIM);
    extdelim=getenv(VPATHLIBEXTDELIM);
    
    if(!delim)
      delim=":";
    if(!extdelim)
      extdelim="::";

    extseperator=getenv(VPATHLIBEXTSEPERATOR);
    if(!extseperator)
      extseperator="=";

    
    s=getenv(VPATH);
    if(!s)
      return NULL;
    
    for(nvpath=1,t=s; (t=vpath_strnstr(t+1,strlen(t+1),extdelim)); nvpath++);
    
    vpath=(struct vpath_st *)malloc((nvpath+1)*sizeof(struct vpath_st));
    
    for(ivpath=0; ivpath<nvpath; ivpath++){
      ext_end=vpath_strnstr(s,strlen(s),extdelim);
      if(!ext_end)
	ext_end=s+strlen(s);
      
      for(n=1, t=s; (t=vpath_strnstr(t+1,strlen(t+1),delim)) && (t<ext_end); n++);
      
      vpath[ivpath].path=malloc(sizeof(struct path_st) * (n+1));
      
      first_path=1;
      for(i=0,t=s; (t<ext_end); s=t+1, i++){
	t=vpath_strnstr(s, strlen(s), delim);
	if(!t)
	  t=ext_end;
	if(first_path & (!vpath_strnstr(s,t-s,extseperator))){
	  /* bad hack for the `GNU make compat' mode: add
	        nice&chop("`/bin/pwd`")=:isexist=`/bin/pwd`:
	     to the front of the vpath, if there's no '=' in the 
	     first vpath element */
	  struct path_st *path;
	  int j;
	  char buf[PATH_MAX];

	  /* first, allocate space for the hack */
	  n+=2;
	  vpath[ivpath].path=realloc(vpath[ivpath].path,
				     sizeof(struct path_st)*(n+1));

	  /* reduce typing errors:*/
	  path=&(vpath[ivpath].path[i]);
	  path->f=NULL;
	  /* add  "nice&chop(\"`/bin/pwd\`")=:" */
	  getcwd(buf,sizeof(buf));

	  j=0;
	  alloc_function(path, &j, nice_func, /* param=*/0, 0);
	  alloc_function(path,&j, chop_func,
			 /* param=*/ buf,
			 func_return_unchanged);
	  alloc_function(path,&j, last_func,/* param=*/ 0, 
			 func_return_unchanged);
	  path->s=malloc(1);
	  *(path->s)=0;
	  i++; /* next path element */

	  
	  /* add "isexist=`/bin/pwd`:" */
	  path=&(vpath[ivpath].path[i]);
	  path->f=NULL;
	  j=0;
	  alloc_function(path, &j, isexist_func,/*param=*/ 0, 
			 func_return_unchanged);
	  alloc_function(path,&j, last_func,/* param=*/ 0, 
			 func_return_unchanged);
	  path->s=strdup(buf);
	  i++;

	  first_path=0;
	}

	vpath_store_path(&(vpath[ivpath].path[i]),s,t-s,first_path);
	first_path=0;
      }
      vpath[ivpath].path[n].f=NULL;
      s=ext_end+strlen(extdelim);
    }
    vpath[nvpath].path=NULL;
  }

  return vpath;
}

static int mod_return(int totr, int r, func_return_enum mod){
  switch(mod){
  case func_return_unchanged:
    break;
  case func_return_ignore:
    r=1;
    break;
  case func_return_not:
    r=!r;
    break;
  }
  totr = r && totr;
  return totr;
}
int vpath_check_pathel(const struct vpath_checkfunc *f,
		       const struct path_st *path,
		       struct process_paths *pr,
		       int *vpath_errno){
  int totr;
  int r, fi;
  totr=1;
  *vpath_errno=-1;

  for(fi=0; totr && f[fi].doit; fi++){
    r=f[fi].doit(fi+f,path,pr,vpath_errno);
    if(*vpath_errno!=-1)
      return 0;
    r=mod_return(totr,r,f[fi].ret_mod);
    totr &=r;
  }
  return totr;
}

int vpath_findpath(char *outpathname, const char *inpathname,
		   mode_t mode, struct stat *st,
		   int *vpath_errno){
  /* return: whether we should lie about file:
             0 In case there's no need to lie.
	     1 Yes, lie about this file's location etc.
  */
  int i,r,ivpath;
  const struct vpath_checkfunc *f;
  char choppedname[PATH_MAX];
  char nicename[PATH_MAX];
  struct process_paths pr;

  *vpath_errno=-1;

  if (!get_vpath()){
    strcpy(outpathname,inpathname);
    return 0;
  }

  pr.st=st;
  pr.inname=inpathname;
  pr.nicename=nicename;
  strcpy((char *)pr.nicename,pr.inname);
  pr.outname=outpathname;
  pr.choppedname=choppedname;
  pr.need_mode=mode;

  for(ivpath=0;vpath[ivpath].path;ivpath++)
    for(i=0; (f=vpath[ivpath].path[i].f); i++){
      r=vpath_check_pathel(f,&(vpath[ivpath].path[i]),&pr,vpath_errno);
      if(*vpath_errno !=-1)
	return 1;
      if(!r && !i) /* first path of a vpath checks if this vpath should */
	break;        /* be considered */
      if(r && i){
	return 1;
      }
    }
  strcpy(outpathname,inpathname);
  return 0;
}

/****************************************************************/
/****************************************************************/
/*                                                              */
/*           directory listing functions:                       */
/*	     opendir, closedir, readdir, telldir, rewinddir     */
/*                                                              */
/****************************************************************/
/****************************************************************/


static int vpath_treecompare(const void *pa, const void *pb){
  return strcmp(((const struct vpath_treekey *)pa)->s,
		((const struct vpath_treekey *)pb)->s);
}

static int vpath_reclen(const struct vpath_treekey *tk){
  struct dirent de;
  unsigned int n;
  n=strlen(tk->s);
  if(n>=sizeof(de.d_name))
    n=sizeof(de.d_name)-1;

  return n + 1 + ((char*)&(de.d_name) - (char*)&(de.d_ino));
}

static void vpath_write_dirent(struct vpath_treekey *tk){
  struct dirent *de;
  int reclen;

  reclen=vpath_reclen(tk);

  de=*(tk->vd);
  de->d_ino=tk->ino;
#ifdef DIRENT_HAS_d_off
  de->d_off=0;
#endif
  de->d_reclen=reclen;
#ifdef DIRENT_HAS_d_type
  de->d_type=0;
#endif
  vpath_strncpy(de->d_name,tk->s,sizeof(de->d_name)-1);
  *(tk->vd)=(void*)((char *)(*tk->vd)+reclen);
}


static void vpath_treeaction(const void *nodep, 
			     const VISIT which, 
			     const int depth){
  void *val;
  struct vpath_treekey *tk;

  int d=depth; /*stop gcc from complaining */
  d=d;
  
  val=*((void**)nodep);
  tk=(struct vpath_treekey*)val;

  switch(which){
  case preorder:
    break;
  case postorder:
    /*     fprintf(stderr,"NODE: %s, nodep=%p\n", tk->s, val); */
    vpath_write_dirent(tk);
    break;
  case endorder:
    (void)tdelete(val, tk->treeroot, vpath_treecompare);
    free(tk->s);
    free(val);
    break;
  case leaf:
/*     fprintf(stderr,"LEAF: %s, nodep=%p\n", ((struct vpath_treekey*)val)->s, val); */
    vpath_write_dirent(tk);
    tdelete(val, tk->treeroot, vpath_treecompare);
    free(tk->s);
    free(val);
    break;
  default:
/*     fprintf(stderr,"Help, vpath_treeaction, which=%i\n",which); */
    break;
    }
  return;
}


int vpath_dir2tree(char *dir, void ** treeroot, void **vd){
  DIR *d;
  struct dirent *de;
  struct vpath_treekey * key;
  struct vpath_treekey * found;
  int size=0;
  
  d=next_opendir(dir);
  if(!d)
    return -1;

  while(d&&(de=next_readdir(d))){
    key=(struct vpath_treekey*)malloc(sizeof(struct vpath_treekey));
    key->s=strdup(de->d_name);
    key->treeroot=treeroot;
    key->ino=de->d_ino;
    key->vd=vd;
  /*   fprintf(stderr,"ino=%li  off=%li  name=%s, key=%p, root=%p\n", */
/* 	   de->d_ino,  */
/* 	   de->d_off, */
/* 	   de->d_name, */
/* 	   key, */
/* 	   treeroot); */
    found=tsearch(key,treeroot,vpath_treecompare);
    if(*(void**)found==(void*)key)
      size+=vpath_reclen(key);
  }
  next_closedir(d);
  return size;
}


DIR *vpath_opendir(const char *dir,
		   int *vpath_errno){
  char outname[PATH_MAX];
  char choppedname[PATH_MAX];
  char nicename[PATH_MAX];
  struct process_paths pr;
  void *data;
  void *treeroot=0;
  int size=0, n, dirfound=0;
  struct vpath_DIR *vpdir;
  int ivpath,i;
  const struct vpath_checkfunc *f;
  int r;
  struct stat st;
  
  *vpath_errno=-1;
  if(!get_vpath())
    return next_opendir(dir);

  vpdir=(struct vpath_DIR *)malloc(sizeof(struct vpath_DIR));

  pr.st=&st;
  pr.inname=dir;
  pr.nicename=nicename;
  strcpy((char *)pr.nicename,pr.inname);
  pr.choppedname=choppedname;
  pr.outname=outname;
  pr.need_mode=S_IFDIR|S_IRUSR|S_IXUSR;

  /* The loop in this opendir() function is somewhat different from the
     loop in vpath_findpath.
     vpath_findpath() simply opens the VPATH elements until it finds a
     file, while vpath_opendir() goes through all VPATH elements, and
     collects possible direcotry elements. However, if a `vpath_errno'
     occurs halfway, we should only return that error if we haven't
     already found other correct directory elelemnts.
  */
  for(ivpath=0;vpath[ivpath].path;ivpath++)
    for(i=0; (f=vpath[ivpath].path[i].f); i++){
      r=vpath_check_pathel(f,&(vpath[ivpath].path[i]),&pr,vpath_errno);
      if(*vpath_errno != -1)
	if(dirfound){
	  *vpath_errno=-1;
	  break;
	} else
	  return NULL;
      if(!r && !i) /* first path of a vpath checks if this vpath should */
	break;     /* be considered */
      if(r && i){
	n = vpath_dir2tree(pr.outname, &treeroot, &data);
	if(n>=0){
	  size += n;
	  dirfound=1;
	}
      }
    }

  if(size){
    vpdir->dirdata=data=malloc(size+sizeof(long));
    vpdir->offset=0;
    twalk(treeroot,vpath_treeaction);
    *(long*)((char*)(vpdir->dirdata)+size)=0;
  }
  else{
    vpdir->offset=-1;
    vpdir->dirdata=next_opendir(dir);
    if(vpdir->dirdata)
      dirfound=1;
  }
  if(dirfound)
    return (DIR *)vpdir;
  else
    return NULL;
}

int vpath_closedir(DIR *dir){
  struct vpath_DIR *vd=(struct vpath_DIR *)dir;
  int r;

  if(!vpath)
    return next_closedir(dir);

  if(vd->offset==-1){
    r=next_closedir(vd->dirdata);
    free(vd);
    return r;
  }
  
  free(vd->dirdata);
  free(vd);
  return 0;
}

struct dirent *vpath_readdir(DIR *dir){
  struct dirent *de;
  struct vpath_DIR *vd=(struct vpath_DIR *)dir;

  if(!vpath)
    return next_readdir(dir);

  if(vd->offset == -1)
    return next_readdir(vd->dirdata);

  de=(void*)((char*)vd->dirdata + vd->offset);
  if(de->d_ino==0)
    return NULL;

  vd->offset += de->d_reclen;
#ifdef STAT_HAS_D_OFF
  de->d_off=vd->offset;
#endif
  return de;  
}

off_t vpath_telldir(DIR *dir){
  struct vpath_DIR *vd=(struct vpath_DIR *)dir;

  if(!vpath)
    return next_telldir(dir);

  if(vd->offset == -1)
    return next_telldir(vd->dirdata);
  
  return vd->offset;
}

/*int vpath_scandir(const char *dir, struct dirent ***namelist,
		  int (*select)(const struct dirent *),
		  int (*compar)(const struct dirent *, const struct dirent *)){
  
}
*/

void vpath_debug (int argc UNUSED, char **argv){
  char buf[PATH_MAX];
  int i,j,k,m;
  struct vpath_checkfunc *f;
  DIR *d;
  struct dirent *de;
  struct stat st;
  int vpath_errno;
  
  printf("libtricks, compiled " __DATE__ " " __TIME__ "\n");
  if(!get_vpath()){
    printf(VPATH " undefined!\n");
    exit(1);
  }

  /*  for(i=0;func_arr[i]; i++)
    printf("%s - %p\n",func_str[i],func_arr[i]);
  */
  for(i=0; vpath[i].path; i++){
    for(j=0;vpath[i].path[j].f; j++){
      printf("VPATH[%i][%i].s=%s\n",i,j,vpath[i].path[j].s);
      for(k=0;(f=&(vpath[i].path[j].f[k])) && f->doit; k++){
	for(m=0;func_arr[m] && (func_arr[m]!=f->doit); m++);
	printf("   f[k].doit=%s, mod=%i, par=%p",
	       func_str[m],f->ret_mod, f->param);
	if(f->doit == do_stdout ||
	   f->doit == do_stdout ||
	   f->doit == do_stderr ||
	   f->doit == do_syslog ||
	   f->doit == do_system ||
	   f->doit == do_check)
	  printf("=%s",(char*)f->param);
	if(f->doit == do_writefile)
	  printf("=(\"%s\", \"%s\")", 
		 ((char**)f->param)[0], ((char**)f->param)[1]);
	if(f->doit==do_settime||
	   f->doit==do_agetime||
	   f->doit==do_return )
	  printf("=%o",*(int*)f->param);
	printf("\n");
      }
    }
  }
  for(i=1; argv[i]; i++){
    vpath_findpath(buf,argv[i],0,&st, &vpath_errno);
    if(vpath_errno==-1)
      printf("file %s -> %s\n",argv[i],buf);
    else
      printf("file %s -> VPATH gererated error: %i=%s\n",
	     argv[i], vpath_errno, strerror(vpath_errno));
  }
  for(i=1; argv[i]; i++){
    d=vpath_opendir(argv[i],&vpath_errno);
    if(vpath_errno!=-1)
      printf("While opening dir %s, VPATH generated error: %i=%s\n",
	     argv[1], vpath_errno, strerror(vpath_errno));
    else if(d){
      while((de=vpath_readdir(d))){
	printf("  %s\n",de->d_name);
      }
    }
  }
}
