""" Demonstration of the Pmw PromptDialog megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create the dialog to prompt for the password.
	self.dialog = Pmw.PromptDialog(parent,
	    title = 'Password',
	    label_text = 'Password:',
	    entryfield_labelpos = 'n',
	    entry_show = '*',
	    defaultbutton = 0,
	    buttons = ('OK', 'Cancel'),
	    command = self.execute)
	self.dialog.withdraw()

	# Create the confirmation dialog.
	self.confirm = Pmw.MessageDialog(
	    title = 'Are you sure?',
	    message_text = 'Are you really sure?',
	    defaultbutton = 0,
	    buttons = ('OK', 'Cancel'))
	self.confirm.withdraw()

	# Create button to launch the dialog.
	w = Tkinter.Button(parent, text = 'Show prompt dialog',
	        command = self.dialog.activate)
	w.pack(padx = 8, pady = 8)

    def execute(self, result):
	if result is None or result == 'Cancel':
	    print 'Password prompt cancelled'
	    self.dialog.deactivate(result)
	else:
	    result = self.confirm.activate()
	    if result == 'OK':
		print 'Password entered ' + self.dialog.get()
		self.dialog.deactivate()

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw PromptDialog demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
