""" Demonstration of how to nest modal Dialog megawidgets.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create button to launch the dialog.
	w = Tkinter.Button(parent, text = 'Show first dialog',
	        command = self.showFirstDialog)
	w.pack(padx = 8, pady = 8)

    def showFirstDialog(self):
	self.dialog1 = Pmw.MessageDialog(
		message_text = 'This is the first modal dialog.\n' +
			'You can see how dialogs nest by\n' +
			'clicking on the "Next" button.',
		title = 'Dialog 1',
		buttons = ('Next', 'Cancel'),
		defaultbutton = 'Next',
		command = self.next_dialog)
	self.dialog1.activate()
	self.dialog1.destroy()

    def next_dialog(self, result):
	if result != 'Next':
	    self.dialog1.deactivate()
	    return

	dialog2 = Pmw.Dialog(
		title = 'Dialog 2',
		buttons = ('Cancel',),
		defaultbutton = 'Cancel')
	w = Tkinter.Label(dialog2.interior(),
	    text = 'This is the second modal dialog.')
	w.pack()

	dialog2.activate()
	dialog2.destroy()

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Modal dialog nesting demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
