""" Demonstration of the Pmw Counter megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import string
import time
import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Need to use long ints here because on the Macintosh the maximum size
	# of an integer is smaller than the value returned by time.time().
	now = (long(time.time()) / 300) * 300

	# Create the Counters.
	self._date = Pmw.Counter(parent,
		labelpos = 'w',
		label_text = 'Date:',
		entryfield_value = time.strftime('%d/%m/%Y',time.gmtime(now)),
	        entryfield_command = self.execute,
	        entryfield_validate = 'date_dmy',
		datatype='date_dmy4')
	self._time = Pmw.Counter(parent,
		labelpos = 'w',
		label_text = 'Time:',
		entryfield_value = time.strftime('%H:%M:%S',time.gmtime(now)),
	        entryfield_validate = 'time24',
	        datatype='time24',
		increment=5*60)
	self._real = Pmw.Counter(parent,
		labelpos = 'w',
		label_text = 'Real:',
		entryfield_value = 1.5,
		datatype = 'real', 
	        entryfield_validate = 'real',
		increment = 0.1,
		max = 5.0,
		min = 0.0)
	self._int = Pmw.Counter(parent,
		labelpos = 'w',
		label_text = 'Integer:',
		orient = 'vertical',
		min = 0,
		max = 99,
		entry_width = 2,
		entryfield_value = 50,
	        entryfield_validate='integer',
		entryfield_maxwidth=3)

	counters = (self._date, self._time, self._real)
	Pmw.alignlabels(counters)

	# Pack them all.
	for counter in counters:
	    counter.pack(fill='x', expand=1, padx=10, pady=5)
	self._int.pack(padx=10, pady=5)

    def execute(self):
	print 'Return pressed, value is', self._date.get()

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw Counter demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
