# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AppliedScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Applied Scope."""

    SINGLE = "Single"
    SHARED = "Shared"
    MANAGEMENT_GROUP = "ManagementGroup"


class BillingPlan(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the billing plan in ISO 8601 format. Required only for monthly billing plans."""

    P1_M = "P1M"


class CommitmentGrain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Commitment grain."""

    HOURLY = "Hourly"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class InstanceFlexibility(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Turning this on will apply the reservation discount to other VMs in the same VM size group."""

    ON = "On"
    OFF = "Off"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PaymentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes whether the payment is completed, failed, cancelled or scheduled in the future."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    SCHEDULED = "Scheduled"
    CANCELLED = "Cancelled"


class PricingCurrencyDuration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents either billing plan or savings plan term in ISO 8601 format."""

    P1_M = "P1M"
    P1_Y = "P1Y"
    P3_Y = "P3Y"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state."""

    CREATING = "Creating"
    PENDING_BILLING = "PendingBilling"
    CONFIRMED_BILLING = "ConfirmedBilling"
    CREATED = "Created"
    SUCCEEDED = "Succeeded"
    CANCELLED = "Cancelled"
    EXPIRED = "Expired"
    FAILED = "Failed"


class ReservedResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the resource that is being reserved."""

    VIRTUAL_MACHINES = "VirtualMachines"
    SQL_DATABASES = "SqlDatabases"
    SUSE_LINUX = "SuseLinux"
    COSMOS_DB = "CosmosDb"
    RED_HAT = "RedHat"
    SQL_DATA_WAREHOUSE = "SqlDataWarehouse"
    V_MWARE_CLOUD_SIMPLE = "VMwareCloudSimple"
    RED_HAT_OSA = "RedHatOsa"
    DATABRICKS = "Databricks"
    APP_SERVICE = "AppService"
    MANAGED_DISK = "ManagedDisk"
    BLOCK_BLOB = "BlockBlob"
    REDIS_CACHE = "RedisCache"
    AZURE_DATA_EXPLORER = "AzureDataExplorer"
    MY_SQL = "MySql"
    MARIA_DB = "MariaDb"
    POSTGRE_SQL = "PostgreSql"
    DEDICATED_HOST = "DedicatedHost"
    SAP_HANA = "SapHana"
    SQL_AZURE_HYBRID_BENEFIT = "SqlAzureHybridBenefit"
    AVS = "AVS"
    DATA_FACTORY = "DataFactory"
    NET_APP_STORAGE = "NetAppStorage"
    AZURE_FILES = "AzureFiles"
    SQL_EDGE = "SqlEdge"
    VIRTUAL_MACHINE_SOFTWARE = "VirtualMachineSoftware"


class Term(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent benefit term in ISO 8601 format."""

    P1_Y = "P1Y"
    P3_Y = "P3Y"
    P5_Y = "P5Y"
